/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.main.service;

import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import org.davidmoten.oa3.codegen.spring.runtime.ControllerExceptionHandler;
import org.davidmoten.oa3.codegen.spring.runtime.RequestPreconditions;
import org.davidmoten.oa3.codegen.test.main.Globals;
import org.davidmoten.oa3.codegen.test.main.schema.AuthenticationRequestBody;
import org.davidmoten.oa3.codegen.test.main.schema.MsiContent;
import org.davidmoten.oa3.codegen.test.main.service.Service;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ServiceController
implements ControllerExceptionHandler {
    private final Service service;

    public ServiceController(@Autowired(required=false) Service service) {
        this.service = (Service)Util.orElse((Object)service, (Object)new Service(){});
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/authenticate"}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<?> getToken(@RequestBody AuthenticationRequestBody requestBody) {
        try {
            return ResponseEntity.status((int)200).body((Object)this.service.getToken(requestBody));
        }
        catch (Throwable e) {
            return this.service.errorResponse(e);
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/msi"}, produces={"application/json"})
    public ResponseEntity<?> getMsis(@RequestParam(name="startTimeMin", required=false) Optional<OffsetDateTime> startTimeMin, @RequestParam(name="startTimeMinInclusive", defaultValue="true", required=false) boolean startTimeMinInclusive, @RequestParam(name="startTimeMax", required=false) Optional<OffsetDateTime> startTimeMax, @RequestParam(name="startTimeMaxInclusive", defaultValue="true", required=false) boolean startTimeMaxInclusive, @RequestParam(name="endTimeMin", required=false) Optional<OffsetDateTime> endTimeMin, @RequestParam(name="endTimeMinInclusive", required=false) Optional<Boolean> endTimeMinInclusive, @RequestParam(name="endTimeMax", required=false) Optional<OffsetDateTime> endTimeMax, @RequestParam(name="endTimeMaxInclusive", defaultValue="true", required=false) boolean endTimeMaxInclusive, @RequestParam(name="limit", defaultValue="10", required=false) int limit, @RequestParam(name="status", required=false) Optional<List<String>> status, @RequestParam(name="broadcastType", required=false) Optional<String> broadcastType, @RequestParam(name="continuationToken", required=false) Optional<String> continuationToken) {
        try {
            if (Globals.config().validateInControllerMethod().test("getMsis")) {
                RequestPreconditions.checkMinimum((Number)limit, (String)"1", (String)"limit", (boolean)false);
            }
            if (Globals.config().validateInControllerMethod().test("getMsis")) {
                RequestPreconditions.checkMinLength(continuationToken, (int)1, (String)"continuationToken");
                RequestPreconditions.checkMaxLength(continuationToken, (int)4096, (String)"continuationToken");
            }
            return ResponseEntity.status((int)200).body((Object)this.service.getMsis(startTimeMin, startTimeMinInclusive, startTimeMax, startTimeMaxInclusive, endTimeMin, endTimeMinInclusive, endTimeMax, endTimeMaxInclusive, limit, status, broadcastType, continuationToken));
        }
        catch (Throwable e) {
            return this.service.errorResponse(e);
        }
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/msi"}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<?> createMsi(@RequestBody MsiContent requestBody) {
        try {
            return ResponseEntity.status((int)201).body((Object)this.service.createMsi(requestBody));
        }
        catch (Throwable e) {
            return this.service.errorResponse(e);
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/msi/{id}"}, produces={"application/json"})
    public ResponseEntity<?> getMsi(@PathVariable(name="id", required=true) String id) {
        try {
            if (Globals.config().validateInControllerMethod().test("getMsi")) {
                RequestPreconditions.checkMinLength((String)id, (int)1, (String)"id");
                RequestPreconditions.checkMaxLength((String)id, (int)255, (String)"id");
            }
            return ResponseEntity.status((int)200).body((Object)this.service.getMsi(id));
        }
        catch (Throwable e) {
            return this.service.errorResponse(e);
        }
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/msi/{id}"})
    public ResponseEntity<?> sendMsi(@PathVariable(name="id", required=true) String id) {
        try {
            if (Globals.config().validateInControllerMethod().test("sendMsi")) {
                RequestPreconditions.checkMinLength((String)id, (int)1, (String)"id");
                RequestPreconditions.checkMaxLength((String)id, (int)255, (String)"id");
            }
            this.service.sendMsi(id);
            return ResponseEntity.status((int)200).build();
        }
        catch (Throwable e) {
            return this.service.errorResponse(e);
        }
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/msi/{id}"})
    public ResponseEntity<?> cancelMsi(@PathVariable(name="id", required=true) String id) {
        try {
            if (Globals.config().validateInControllerMethod().test("cancelMsi")) {
                RequestPreconditions.checkMinLength((String)id, (int)1, (String)"id");
                RequestPreconditions.checkMaxLength((String)id, (int)255, (String)"id");
            }
            this.service.cancelMsi(id);
            return ResponseEntity.status((int)200).build();
        }
        catch (Throwable e) {
            return this.service.errorResponse(e);
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/msi/{id}/status"}, produces={"application/json"})
    public ResponseEntity<?> getMsiStatus(@PathVariable(name="id", required=true) String id) {
        try {
            if (Globals.config().validateInControllerMethod().test("getMsiStatus")) {
                RequestPreconditions.checkMinLength((String)id, (int)1, (String)"id");
                RequestPreconditions.checkMaxLength((String)id, (int)255, (String)"id");
            }
            return ResponseEntity.status((int)200).body((Object)this.service.getMsiStatus(id));
        }
        catch (Throwable e) {
            return this.service.errorResponse(e);
        }
    }
}

