/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.paths.path;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.paths.Globals;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class QueryObjectGetIdParameterId {
    @JsonProperty(value="first")
    private final String first;
    @JsonProperty(value="second")
    private final Long second;

    @JsonCreator
    private QueryObjectGetIdParameterId(@JsonProperty(value="first") String first, @JsonProperty(value="second") Long second) {
        this.first = first;
        this.second = second;
    }

    @ConstructorBinding
    public QueryObjectGetIdParameterId(String first, Optional<Long> second) {
        if (Globals.config().validateInConstructor().test(QueryObjectGetIdParameterId.class)) {
            Preconditions.checkNotNull((Object)first, (String)"first");
            Preconditions.checkNotNull(second, (String)"second");
        }
        this.first = first;
        this.second = second.orElse(null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String first() {
        return this.first;
    }

    public Optional<Long> second() {
        return Optional.ofNullable(this.second);
    }

    public QueryObjectGetIdParameterId withFirst(String first) {
        return new QueryObjectGetIdParameterId(first, Optional.ofNullable(this.second));
    }

    public QueryObjectGetIdParameterId withSecond(Optional<Long> second) {
        return new QueryObjectGetIdParameterId(this.first, second);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryObjectGetIdParameterId other = (QueryObjectGetIdParameterId)o;
        return Objects.equals(this.first, other.first) && Objects.equals(this.second, other.second);
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    public String toString() {
        return Util.toString(QueryObjectGetIdParameterId.class, (Object[])new Object[]{"first", this.first, "second", this.second});
    }

    public static final class BuilderWithFirst {
        private final Builder b;

        BuilderWithFirst(Builder b) {
            this.b = b;
        }

        public BuilderWithFirst second(long second) {
            this.b.second = Optional.of(second);
            return this;
        }

        public BuilderWithFirst second(Optional<Long> second) {
            this.b.second = second;
            return this;
        }

        public QueryObjectGetIdParameterId build() {
            return new QueryObjectGetIdParameterId(this.b.first, this.b.second);
        }
    }

    public static final class Builder {
        private String first;
        private Optional<Long> second = Optional.empty();

        Builder() {
        }

        public BuilderWithFirst first(String first) {
            this.first = first;
            return new BuilderWithFirst(this);
        }
    }
}

