/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.paths.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.paths.Globals;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class Error {
    @JsonProperty(value="statusCode")
    private final Long statusCode;
    @JsonProperty(value="errorMessage")
    private final String errorMessage;

    @JsonCreator
    private Error(@JsonProperty(value="statusCode") Long statusCode, @JsonProperty(value="errorMessage") String errorMessage) {
        this.statusCode = statusCode;
        this.errorMessage = errorMessage;
    }

    @ConstructorBinding
    public Error(Optional<Long> statusCode, Optional<String> errorMessage) {
        if (Globals.config().validateInConstructor().test(Error.class)) {
            Preconditions.checkNotNull(statusCode, (String)"statusCode");
            Preconditions.checkNotNull(errorMessage, (String)"errorMessage");
        }
        this.statusCode = statusCode.orElse(null);
        this.errorMessage = errorMessage.orElse(null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<Long> statusCode() {
        return Optional.ofNullable(this.statusCode);
    }

    public Optional<String> errorMessage() {
        return Optional.ofNullable(this.errorMessage);
    }

    public Error withStatusCode(Optional<Long> statusCode) {
        return new Error(statusCode, Optional.ofNullable(this.errorMessage));
    }

    public Error withErrorMessage(Optional<String> errorMessage) {
        return new Error(Optional.ofNullable(this.statusCode), errorMessage);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Error other = (Error)o;
        return Objects.equals(this.statusCode, other.statusCode) && Objects.equals(this.errorMessage, other.errorMessage);
    }

    public int hashCode() {
        return Objects.hash(this.statusCode, this.errorMessage);
    }

    public String toString() {
        return Util.toString(Error.class, (Object[])new Object[]{"statusCode", this.statusCode, "errorMessage", this.errorMessage});
    }

    public static final class Builder {
        private Optional<Long> statusCode = Optional.empty();
        private Optional<String> errorMessage = Optional.empty();

        Builder() {
        }

        public Builder statusCode(long statusCode) {
            this.statusCode = Optional.of(statusCode);
            return this;
        }

        public Builder statusCode(Optional<Long> statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = Optional.of(errorMessage);
            return this;
        }

        public Builder errorMessage(Optional<String> errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public Error build() {
            return new Error(this.statusCode, this.errorMessage);
        }
    }
}

