/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.paths.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class Point {
    @JsonProperty(value="lat")
    private final double lat;
    @JsonProperty(value="lon")
    private final double lon;

    @JsonCreator
    @ConstructorBinding
    public Point(@JsonProperty(value="lat") double lat, @JsonProperty(value="lon") double lon) {
        this.lat = lat;
        this.lon = lon;
    }

    public static Builder builder() {
        return new Builder();
    }

    public double lat() {
        return this.lat;
    }

    public double lon() {
        return this.lon;
    }

    public Point withLat(double lat) {
        return new Point(lat, this.lon);
    }

    public Point withLon(double lon) {
        return new Point(this.lat, lon);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Point other = (Point)o;
        return Objects.equals(this.lat, other.lat) && Objects.equals(this.lon, other.lon);
    }

    public int hashCode() {
        return Objects.hash(this.lat, this.lon);
    }

    public String toString() {
        return Util.toString(Point.class, (Object[])new Object[]{"lat", this.lat, "lon", this.lon});
    }

    public static final class BuilderWithLon {
        private final Builder b;

        BuilderWithLon(Builder b) {
            this.b = b;
        }

        public Point build() {
            return new Point(this.b.lat, this.b.lon);
        }
    }

    public static final class BuilderWithLat {
        private final Builder b;

        BuilderWithLat(Builder b) {
            this.b = b;
        }

        public BuilderWithLon lon(double lon) {
            this.b.lon = lon;
            return new BuilderWithLon(this.b);
        }
    }

    public static final class Builder {
        private double lat;
        private double lon;

        Builder() {
        }

        public BuilderWithLat lat(double lat) {
            this.lat = lat;
            return new BuilderWithLat(this);
        }
    }
}

