/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.paths.service;

import java.time.OffsetDateTime;
import java.util.Optional;
import org.davidmoten.oa3.codegen.spring.runtime.ControllerExceptionHandler;
import org.davidmoten.oa3.codegen.spring.runtime.RequestPreconditions;
import org.davidmoten.oa3.codegen.test.paths.Globals;
import org.davidmoten.oa3.codegen.test.paths.path.QueryObjectGetIdParameterId;
import org.davidmoten.oa3.codegen.test.paths.schema.Point;
import org.davidmoten.oa3.codegen.test.paths.schema.RequestBody1;
import org.davidmoten.oa3.codegen.test.paths.schema.RequestBody2;
import org.davidmoten.oa3.codegen.test.paths.service.Service;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ServiceController
implements ControllerExceptionHandler {
    private final Service service;

    public ServiceController(@Autowired(required=false) Service service) {
        this.service = (Service)Util.orElse((Object)service, (Object)new Service(){});
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/requestBodyRequired"}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<?> requestBodyRequiredPost(@RequestBody RequestBody1 requestBody) {
        try {
            return ResponseEntity.status((int)200).body((Object)this.service.requestBodyRequiredPost(requestBody));
        }
        catch (Throwable e) {
            return this.service.errorResponse(e);
        }
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/requestBodyNotRequired"}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<?> requestBodyNotRequiredPost(@RequestBody Optional<RequestBody2> requestBody) {
        try {
            return ResponseEntity.status((int)200).body((Object)this.service.requestBodyNotRequiredPost(requestBody));
        }
        catch (Throwable e) {
            return this.service.errorResponse(e);
        }
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/requestBodyRef"}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<?> requestBodyRefPost(@RequestBody RequestBody1 requestBody) {
        try {
            return ResponseEntity.status((int)200).body((Object)this.service.requestBodyRefPost(requestBody));
        }
        catch (Throwable e) {
            return this.service.errorResponse(e);
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/responseMultiType"}, produces={"application/json", "application/octet-stream"})
    public ResponseEntity<?> responseMultiTypeGet(@RequestHeader(name="Accept", defaultValue="application/json", required=false) String accept, @RequestParam(name="username", required=true) String username) {
        try {
            if (Globals.config().validateInControllerMethod().test("responseMultiTypeGet")) {
                RequestPreconditions.checkMinLength((String)username, (int)1, (String)"username");
            }
            return ResponseEntity.status((int)200).body((Object)this.service.responseMultiTypeGet(accept, username));
        }
        catch (Throwable e) {
            return this.service.errorResponse(e);
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/bytes"}, produces={"application/octet-stream"})
    public ResponseEntity<?> bytesGet() {
        try {
            return ResponseEntity.status((int)200).body((Object)this.service.bytesGet());
        }
        catch (Throwable e) {
            return this.service.errorResponse(e);
        }
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/upload"}, consumes={"multipart/form-data"}, produces={"application/json"})
    public ResponseEntity<?> uploadPost() {
        try {
            return ResponseEntity.status((int)200).body(this.service.uploadPost());
        }
        catch (Throwable e) {
            return this.service.errorResponse(e);
        }
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/uploadImage"}, consumes={"image/png"}, produces={"application/json"})
    public ResponseEntity<?> uploadImagePost() {
        try {
            return ResponseEntity.status((int)200).body(this.service.uploadImagePost());
        }
        catch (Throwable e) {
            return this.service.errorResponse(e);
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/defaultError"}, produces={"application/json"})
    public ResponseEntity<?> defaultErrorGet() {
        try {
            return ResponseEntity.status((int)200).body((Object)this.service.defaultErrorGet());
        }
        catch (Throwable e) {
            return this.service.errorResponse(e);
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/text"}, produces={"text/plain"})
    public ResponseEntity<?> textGet() {
        try {
            return ResponseEntity.status((int)200).body((Object)this.service.textGet());
        }
        catch (Throwable e) {
            return this.service.errorResponse(e);
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/jsonString"}, produces={"application/json"})
    public ResponseEntity<?> jsonStringGet() {
        try {
            return ResponseEntity.status((int)200).body((Object)this.service.jsonStringGet());
        }
        catch (Throwable e) {
            return this.service.errorResponse(e);
        }
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/requestBodyMultiType"}, consumes={"application/json", "application/octet-stream"}, produces={"application/json"})
    public ResponseEntity<?> requestBodyMultiTypePost(@RequestBody RequestBody1 requestBody) {
        try {
            return ResponseEntity.status((int)200).body((Object)this.service.requestBodyMultiTypePost(requestBody));
        }
        catch (Throwable e) {
            return this.service.errorResponse(e);
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/item"}, produces={"application/json"})
    public ResponseEntity<?> itemGet() {
        try {
            return ResponseEntity.status((int)200).body((Object)this.service.itemGet());
        }
        catch (Throwable e) {
            return this.service.errorResponse(e);
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/item201"}, produces={"application/json"})
    public ResponseEntity<?> item201Get() {
        try {
            return ResponseEntity.status((int)201).body((Object)this.service.item201Get());
        }
        catch (Throwable e) {
            return this.service.errorResponse(e);
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/responseRef"}, produces={"application/json"})
    public ResponseEntity<?> responseRefGet() {
        try {
            return ResponseEntity.status((int)200).body((Object)this.service.responseRefGet());
        }
        catch (Throwable e) {
            return this.service.errorResponse(e);
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/responseRef2"}, produces={"application/json"})
    public ResponseEntity<?> responseRef2Get() {
        try {
            return ResponseEntity.status((int)200).body((Object)this.service.responseRef2Get());
        }
        catch (Throwable e) {
            return this.service.errorResponse(e);
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/empty"})
    public ResponseEntity<?> emptyGet() {
        try {
            this.service.emptyGet();
            return ResponseEntity.status((int)200).build();
        }
        catch (Throwable e) {
            return this.service.errorResponse(e);
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/params"}, produces={"application/json"})
    public ResponseEntity<?> paramsGet(@RequestParam(name="id", required=true) String id, @RequestParam(name="first", required=true) OffsetDateTime first, @RequestParam(name="second", required=false) Optional<Long> second, @RequestParam(name="third", defaultValue="10", required=false) int third) {
        try {
            if (Globals.config().validateInControllerMethod().test("paramsGet")) {
                RequestPreconditions.checkMinLength((String)id, (int)1, (String)"id");
            }
            return ResponseEntity.status((int)203).body((Object)this.service.paramsGet(id, first, second, third));
        }
        catch (Throwable e) {
            return this.service.errorResponse(e);
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/params/{id}"}, produces={"application/json"})
    public ResponseEntity<?> paramsIdGet(@PathVariable(name="id", required=true) String id, @RequestHeader(name="ApiKey", required=true) String apiKey, @CookieValue(name="bickie", required=true) String bickie) {
        try {
            if (Globals.config().validateInControllerMethod().test("paramsIdGet")) {
                RequestPreconditions.checkMinLength((String)id, (int)1, (String)"id");
            }
            if (Globals.config().validateInControllerMethod().test("paramsIdGet")) {
                RequestPreconditions.checkMinLength((String)apiKey, (int)1, (String)"apiKey");
            }
            if (Globals.config().validateInControllerMethod().test("paramsIdGet")) {
                RequestPreconditions.checkMinLength((String)bickie, (int)1, (String)"bickie");
            }
            return ResponseEntity.status((int)200).body((Object)this.service.paramsIdGet(id, apiKey, bickie));
        }
        catch (Throwable e) {
            return this.service.errorResponse(e);
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/query-object"})
    public ResponseEntity<?> queryObjectGet(@ModelAttribute(name="id") QueryObjectGetIdParameterId id) {
        try {
            this.service.queryObjectGet(id);
            return ResponseEntity.status((int)200).build();
        }
        catch (Throwable e) {
            return this.service.errorResponse(e);
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/points"})
    public ResponseEntity<?> pointsGet(@ModelAttribute(name="a") Point a, @ModelAttribute(name="b") Point b) {
        try {
            this.service.pointsGet(a, b);
            return ResponseEntity.status((int)200).build();
        }
        catch (Throwable e) {
            return this.service.errorResponse(e);
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/paramRef"}, produces={"application/json"})
    public ResponseEntity<?> paramRefGet(@RequestParam(name="id", required=true) String id, @RequestParam(name="first", required=true) OffsetDateTime first) {
        try {
            if (Globals.config().validateInControllerMethod().test("paramRefGet")) {
                RequestPreconditions.checkMinLength((String)id, (int)1, (String)"id");
            }
            return ResponseEntity.status((int)203).body((Object)this.service.paramRefGet(id, first));
        }
        catch (Throwable e) {
            return this.service.errorResponse(e);
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/parameterNameCollision"})
    public ResponseEntity<?> parameterNameCollisionGet(@RequestParam(name="a", required=true) String a, @RequestParam(name="A", required=true) String a2) {
        try {
            this.service.parameterNameCollisionGet(a, a2);
            return ResponseEntity.status((int)200).build();
        }
        catch (Throwable e) {
            return this.service.errorResponse(e);
        }
    }
}

