/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.plugin;

import com.github.davidmoten.guavamini.Sets;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.io.FileUtils;
import org.davidmoten.oa3.codegen.generator.ClientServerGenerator;
import org.davidmoten.oa3.codegen.generator.Definition;
import org.davidmoten.oa3.codegen.generator.DownloadExtras;
import org.davidmoten.oa3.codegen.generator.Generator;
import org.davidmoten.oa3.codegen.generator.Packages;
import org.davidmoten.oa3.codegen.util.Util;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=false)
public final class GenerateMojo
extends AbstractMojo {
    @Parameter(name="sources")
    private FileSet sources;
    @Parameter(name="outputDirectory", defaultValue="${project.build.directory}/generated-sources/java")
    private File outputDirectory;
    @Parameter(name="basePackage", defaultValue="openapi.generated")
    private String basePackage;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(name="includeSchemas")
    private List<String> includeSchemas;
    @Parameter(name="excludeSchemas")
    private List<String> excludeSchemas;
    @Parameter(name="mapIntegerToBigInteger", defaultValue="false")
    private boolean mapIntegerToBigInteger;
    @Parameter(name="mapNumberToBigDecimal", defaultValue="false")
    private boolean mapNumberToBigDecimal;
    @Parameter(name="failOnParseErrors", defaultValue="true")
    private boolean failOnParseErrors;
    @Parameter(name="generator", defaultValue="spring2")
    private String generator;
    @Parameter(name="generateService", defaultValue="true")
    private boolean generateService;
    @Parameter(name="generateClient", defaultValue="true")
    private boolean generateClient;
    @Parameter(name="downloadList")
    private File downloadList;
    @Parameter(name="cacheDirectory", defaultValue="${project.basedir}/.openapi-codegen/cache")
    private File cacheDirectory;
    @Parameter(name="skip", defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            System.out.println("[INFO] skipping");
            return;
        }
        if (this.downloadList != null) {
            DownloadExtras.run((File)this.downloadList, (File)this.cacheDirectory);
        }
        File defaultSourceDirectory = new File(this.project.getBasedir(), "src" + File.separator + "main" + File.separator + "openapi");
        if (this.sources == null) {
            this.sources = new FileSet();
            this.sources.setDirectory(defaultSourceDirectory.getAbsolutePath());
        }
        this.getLog().info((CharSequence)("sources=" + this.sources));
        try {
            if (this.sources.getDirectory() == null) {
                this.sources.setDirectory(defaultSourceDirectory.getAbsolutePath());
            }
            if (this.sources.getIncludes().isEmpty()) {
                this.sources.addInclude("**/*.yml");
                this.sources.addInclude("**/*.yaml");
            }
            List files = FileUtils.getFiles((File)new File(this.sources.getDirectory()), (String)GenerateMojo.commaSeparate(this.sources.getIncludes()), (String)GenerateMojo.commaSeparate(this.sources.getExcludes()));
            for (File file : files) {
                this.getLog().info((CharSequence)file.toString());
                String definition = file.toURI().toURL().toExternalForm();
                Packages packages = new Packages(this.basePackage);
                Definition d = new Definition(definition, packages, this.outputDirectory, x -> x, (Set)Sets.newHashSet((Iterable)((Iterable)Util.orElse(this.includeSchemas, Collections.emptyList()))), (Set)Sets.newHashSet((Iterable)((Iterable)Util.orElse(this.excludeSchemas, Collections.emptyList()))), this.mapIntegerToBigInteger, this.mapNumberToBigDecimal, this.failOnParseErrors, Optional.ofNullable(this.generator), this.generateService);
                new Generator(d).generate();
                if (!this.generateService && !this.generateClient) continue;
                ClientServerGenerator g = new ClientServerGenerator(d);
                if (this.generateService) {
                    g.generateServer();
                }
                if (!this.generateClient) continue;
                g.generateClient();
            }
            this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private static String commaSeparate(List<String> list) {
        return list.stream().collect(Collectors.joining(","));
    }
}

