/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.runtime;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.github.davidmoten.guavamini.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.davidmoten.oa3.codegen.runtime.Config;
import org.openapitools.jackson.nullable.JsonNullable;

public class AnyOfSerializer<T>
extends StdSerializer<T> {
    private static final long serialVersionUID = -8290019952172548639L;
    private final Class<T> cls;
    private final ObjectMapper mapper;

    protected AnyOfSerializer(Config config, Class<T> cls) {
        super(cls);
        this.cls = cls;
        this.mapper = config.mapper();
    }

    public void serialize(T value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        List values = Arrays.stream(this.cls.getDeclaredFields()).filter(f -> !f.getName().startsWith("$")).map(f -> {
            try {
                f.setAccessible(true);
                return f.get(value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }).filter(x -> x instanceof Optional || x instanceof JsonNullable).collect(Collectors.toList());
        Optional node = values.stream().filter(x -> x instanceof Optional && ((Optional)x).isPresent() || x instanceof JsonNullable && ((JsonNullable)x).isPresent()).map(x -> {
            try {
                return this.mapper.writeValueAsString(x);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }).map(x -> {
            try {
                return this.mapper.readTree(x);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.reducing((a, b) -> AnyOfSerializer.merge(a, b)));
        if (!node.isPresent()) {
            throw new IllegalStateException("at least one of the anyOf members must be present");
        }
        gen.writeTree((TreeNode)node.get());
    }

    @VisibleForTesting
    static JsonNode merge(JsonNode a, JsonNode b) {
        if (a.equals((Object)b)) {
            return a;
        }
        if (a.getNodeType() != b.getNodeType()) {
            throw new IllegalArgumentException("merge error: mismatching node types: " + a + ", " + b);
        }
        if (a.isArray()) {
            ArrayNode x = (ArrayNode)a;
            ArrayNode y = (ArrayNode)b;
            if (x.size() != y.size()) {
                throw new IllegalArgumentException("merge error: array lengths don't match, " + a + ", " + b);
            }
            for (int i = 0; i < x.size(); ++i) {
                AnyOfSerializer.merge(x.get(i), y.get(i));
            }
        } else if (a.isObject()) {
            Iterator it = b.fieldNames();
            while (it.hasNext()) {
                String fieldName = (String)it.next();
                JsonNode node = a.get(fieldName);
                if (node != null) {
                    AnyOfSerializer.merge(node, b.get(fieldName));
                    continue;
                }
                JsonNode value = b.get(fieldName);
                ((ObjectNode)a).replace(fieldName, value);
            }
        } else {
            throw new IllegalArgumentException("merge error, fields not equal: " + a + ", " + b);
        }
        return a;
    }
}

