/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.runtime;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.davidmoten.oa3.codegen.util.Util;
import org.openapitools.jackson.nullable.JsonNullable;

public class JsonNullableOctetsDeserializer
extends StdDeserializer<JsonNullable<byte[]>> {
    private static final long serialVersionUID = 1L;

    public JsonNullableOctetsDeserializer() {
        super(JsonNullable.class);
    }

    public JsonNullable<byte[]> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_STRING) {
            String str = p.getText().trim();
            if (str.isEmpty()) {
                return JsonNullable.undefined();
            }
            byte[] bytes = Util.decodeOctets((String)str);
            return JsonNullable.of((Object)bytes);
        }
        if (t == JsonToken.VALUE_NULL) {
            return JsonNullable.of(null);
        }
        throw new RuntimeException("unexpected");
    }

    public Object getAbsentValue(DeserializationContext ctxt) {
        return JsonNullable.undefined();
    }

    public JsonNullable<byte[]> getNullValue(DeserializationContext ctxt) {
        return JsonNullable.of(null);
    }

    public Object getEmptyValue(DeserializationContext ctxt) {
        return JsonNullable.undefined();
    }

    public Boolean supportsUpdate(DeserializationConfig config) {
        return Boolean.TRUE;
    }
}

