/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.parallel;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="exec", threadSafe=true)
public final class ParallelExecMojo
extends AbstractMojo {
    @Parameter(name="poolSize", defaultValue="0")
    private int poolSize;
    @Parameter(name="timeoutSeconds", defaultValue="30")
    private long timeoutSeconds;
    @Parameter(name="separateLogs", defaultValue="false")
    private boolean separateLogs;
    @Parameter(name="commands")
    private List<Command> commands;

    public void execute() throws MojoExecutionException {
        this.poolSize = this.poolSize == 0 ? Runtime.getRuntime().availableProcessors() : this.poolSize;
        ExecutorService executor = Executors.newFixedThreadPool(this.poolSize);
        CopyOnWriteArrayList errors = new CopyOnWriteArrayList();
        ArrayList<File> logs = new ArrayList<File>();
        int i = 0;
        while (i < this.commands.size()) {
            int index = i++;
            logs.add(new File("target" + File.separator + "command" + index + ".log"));
            executor.execute(() -> {
                try {
                    this.commands.get(index).start(this.getLog(), (File)logs.get(index));
                }
                catch (Throwable e) {
                    errors.add(e);
                }
            });
        }
        this.getLog().info((CharSequence)("awaiting finish of " + this.commands.size() + " commands"));
        executor.shutdown();
        try {
            executor.awaitTermination(this.timeoutSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        if (this.separateLogs) {
            for (File log : logs) {
                this.getLog().info((CharSequence)("************** " + log.getPath()));
                try {
                    Files.readAllLines(log.toPath()).forEach(System.out::println);
                }
                catch (IOException e3) {
                    throw new MojoExecutionException((Throwable)e3);
                }
            }
        }
        errors.forEach(e -> this.getLog().error(e));
        if (!errors.isEmpty()) {
            throw new MojoExecutionException((Throwable)errors.get(0));
        }
    }

    public static final class Command {
        @Parameter(name="executable")
        String executable;
        @Parameter(name="arguments")
        List<String> arguments;
        @Parameter(name="workingDirectory")
        String workingDirectory;

        void start(Log log, File output) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.executable);
            list.addAll(this.arguments);
            if (this.workingDirectory == null) {
                this.workingDirectory = ".";
            }
            ProcessBuilder b = new ProcessBuilder(list).directory(new File(this.workingDirectory)).inheritIO();
            try {
                b.start().waitFor();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            log.info((CharSequence)("finished command: " + list));
        }
    }
}

