/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.jdbc;

import com.github.davidmoten.rx.RxUtil;
import com.github.davidmoten.rx.jdbc.Parameter;
import com.github.davidmoten.rx.jdbc.Query;
import com.github.davidmoten.rx.jdbc.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import rx.Observable;
import rx.functions.Func1;

final class Queries {
    private static final Func1<Parameter, Observable<Parameter>> FLATTEN_NAMED_MAPS = new Func1<Parameter, Observable<Parameter>>(){

        public Observable<Parameter> call(Parameter p) {
            if (p.value() instanceof Map) {
                ArrayList<Parameter> list = new ArrayList<Parameter>();
                for (Map.Entry entry : ((Map)p.value()).entrySet()) {
                    list.add(new Parameter((String)entry.getKey(), entry.getValue()));
                }
                return Observable.from(list);
            }
            return Observable.from(Arrays.asList(p));
        }
    };

    private Queries() {
    }

    static int numParamsPerQuery(Query query) {
        return Util.parametersCount(query);
    }

    static Observable<Parameter> parametersAfterDependencies(Query query) {
        return RxUtil.concatButIgnoreFirstSequence(query.depends(), query.parameters());
    }

    static Observable<Integer> singleIntegerAfterDependencies(Query query) {
        return RxUtil.concatButIgnoreFirstSequence(query.depends(), Observable.just((Object)1));
    }

    static Observable<List<Parameter>> bufferedParameters(Query query) {
        int numParamsPerQuery = Queries.numParamsPerQuery(query);
        if (numParamsPerQuery > 0) {
            return Queries.parametersAfterDependencies(query).concatMap(FLATTEN_NAMED_MAPS).buffer(numParamsPerQuery);
        }
        return Queries.singleIntegerAfterDependencies(query).map(Util.TO_EMPTY_PARAMETER_LIST);
    }
}

