/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2;

import com.github.davidmoten.guavamini.Optional;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.rx2.Consumers;
import com.github.davidmoten.rx2.Functions;
import io.reactivex.Flowable;
import io.reactivex.Scheduler;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;

public final class RetryWhen {
    private static final long NO_MORE_DELAYS = -1L;
    private static BiFunction<Throwable, Long, ErrorAndDuration> TO_ERROR_AND_DURATION = new BiFunction<Throwable, Long, ErrorAndDuration>(){

        public ErrorAndDuration apply(Throwable throwable, Long durationMs) {
            return new ErrorAndDuration(throwable, durationMs);
        }
    };

    private RetryWhen() {
    }

    private static Function<Flowable<? extends Throwable>, Flowable<Object>> notificationHandler(Flowable<Long> delays, Scheduler scheduler, Consumer<? super ErrorAndDuration> action, List<Class<? extends Throwable>> retryExceptions, List<Class<? extends Throwable>> failExceptions, Predicate<? super Throwable> exceptionPredicate) {
        Function<ErrorAndDuration, Flowable<ErrorAndDuration>> checkExceptions = RetryWhen.createExceptionChecker(retryExceptions, failExceptions, exceptionPredicate);
        return RetryWhen.createNotificationHandler(delays, scheduler, action, checkExceptions);
    }

    private static Function<Flowable<? extends Throwable>, Flowable<Object>> createNotificationHandler(final Flowable<Long> delays, final Scheduler scheduler, final Consumer<? super ErrorAndDuration> action, final Function<ErrorAndDuration, Flowable<ErrorAndDuration>> checkExceptions) {
        return new Function<Flowable<? extends Throwable>, Flowable<Object>>(){

            public Flowable<Object> apply(Flowable<? extends Throwable> errors) {
                return errors.zipWith((Publisher)delays.concatWith((Publisher)Flowable.just((Object)-1L)), TO_ERROR_AND_DURATION).flatMap(checkExceptions).doOnNext(RetryWhen.callActionExceptForLast((Consumer<? super ErrorAndDuration>)action)).flatMap(RetryWhen.delay(scheduler));
            }
        };
    }

    private static Consumer<ErrorAndDuration> callActionExceptForLast(final Consumer<? super ErrorAndDuration> action) {
        return new Consumer<ErrorAndDuration>(){

            public void accept(ErrorAndDuration e) throws Exception {
                if (e.durationMs() != -1L) {
                    action.accept((Object)e);
                }
            }
        };
    }

    private static Function<ErrorAndDuration, Flowable<ErrorAndDuration>> createExceptionChecker(final List<Class<? extends Throwable>> retryExceptions, final List<Class<? extends Throwable>> failExceptions, final Predicate<? super Throwable> exceptionPredicate) {
        return new Function<ErrorAndDuration, Flowable<ErrorAndDuration>>(){

            public Flowable<ErrorAndDuration> apply(ErrorAndDuration e) throws Exception {
                if (!exceptionPredicate.test((Object)e.throwable())) {
                    return Flowable.error((Throwable)e.throwable());
                }
                for (Class cls : failExceptions) {
                    if (!e.throwable().getClass().isAssignableFrom(cls)) continue;
                    return Flowable.error((Throwable)e.throwable());
                }
                if (retryExceptions.size() > 0) {
                    for (Class cls : retryExceptions) {
                        if (!e.throwable().getClass().isAssignableFrom(cls)) continue;
                        return Flowable.just((Object)e);
                    }
                    return Flowable.error((Throwable)e.throwable());
                }
                return Flowable.just((Object)e);
            }
        };
    }

    private static Function<ErrorAndDuration, Flowable<ErrorAndDuration>> delay(final Scheduler scheduler) {
        return new Function<ErrorAndDuration, Flowable<ErrorAndDuration>>(){

            public Flowable<ErrorAndDuration> apply(ErrorAndDuration e) {
                if (e.durationMs() == -1L) {
                    return Flowable.error((Throwable)e.throwable());
                }
                return Flowable.timer((long)e.durationMs(), (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)scheduler).map(Functions.constant(e));
            }
        };
    }

    public static Builder retryWhenInstanceOf(Class<? extends Throwable> ... classes) {
        return new Builder().retryWhenInstanceOf(classes);
    }

    public static Builder failWhenInstanceOf(Class<? extends Throwable> ... classes) {
        return new Builder().failWhenInstanceOf(classes);
    }

    public static Builder retryIf(Predicate<Throwable> predicate) {
        return new Builder().retryIf(predicate);
    }

    public static Builder delays(Flowable<Long> delays, TimeUnit unit) {
        return new Builder().delays(delays, unit);
    }

    public static Builder delaysInt(Flowable<Integer> delays, TimeUnit unit) {
        return new Builder().delaysInt(delays, unit);
    }

    public static Builder delay(long delay, TimeUnit unit) {
        return new Builder().delay(delay, unit);
    }

    public static Builder maxRetries(int maxRetries) {
        return new Builder().maxRetries(maxRetries);
    }

    public static Builder scheduler(Scheduler scheduler) {
        return new Builder().scheduler(scheduler);
    }

    public static Builder action(Consumer<? super ErrorAndDuration> action) {
        return new Builder().action(action);
    }

    public static Builder exponentialBackoff(long firstDelay, TimeUnit unit, double factor) {
        return new Builder().exponentialBackoff(firstDelay, unit, factor);
    }

    public static Builder exponentialBackoff(long firstDelay, TimeUnit unit) {
        return new Builder().exponentialBackoff(firstDelay, unit);
    }

    public static final class ErrorAndDuration {
        private final Throwable throwable;
        private final long durationMs;

        public ErrorAndDuration(Throwable throwable, long durationMs) {
            this.throwable = throwable;
            this.durationMs = durationMs;
        }

        public Throwable throwable() {
            return this.throwable;
        }

        public long durationMs() {
            return this.durationMs;
        }
    }

    public static final class Builder {
        private final List<Class<? extends Throwable>> retryExceptions = new ArrayList<Class<? extends Throwable>>();
        private final List<Class<? extends Throwable>> failExceptions = new ArrayList<Class<? extends Throwable>>();
        private Predicate<? super Throwable> exceptionPredicate = io.reactivex.internal.functions.Functions.alwaysTrue();
        private Flowable<Long> delays = Flowable.just((Object)0L).repeat();
        private Optional<Integer> maxRetries = Optional.absent();
        private Optional<Scheduler> scheduler = Optional.of((Object)Schedulers.computation());
        private Consumer<? super ErrorAndDuration> action = Consumers.doNothing();

        private Builder() {
        }

        public Builder retryWhenInstanceOf(Class<? extends Throwable> ... classes) {
            this.retryExceptions.addAll(Arrays.asList(classes));
            return this;
        }

        public Builder failWhenInstanceOf(Class<? extends Throwable> ... classes) {
            this.failExceptions.addAll(Arrays.asList(classes));
            return this;
        }

        public Builder retryIf(Predicate<Throwable> predicate) {
            this.exceptionPredicate = predicate;
            return this;
        }

        public Builder delays(Flowable<Long> delays, TimeUnit unit) {
            this.delays = delays.map(Builder.toMillis(unit));
            return this;
        }

        public Builder delaysInt(Flowable<Integer> delays, TimeUnit unit) {
            return this.delays((Flowable<Long>)delays.map(ToLongHolder.INSTANCE), unit);
        }

        public Builder delay(Long delay, TimeUnit unit) {
            this.delays = Flowable.just((Object)delay).map(Builder.toMillis(unit)).repeat();
            return this;
        }

        private static Function<Long, Long> toMillis(final TimeUnit unit) {
            return new Function<Long, Long>(){

                public Long apply(Long t) {
                    return unit.toMillis(t);
                }
            };
        }

        public Builder maxRetries(int maxRetries) {
            this.maxRetries = Optional.of((Object)maxRetries);
            return this;
        }

        public Builder scheduler(Scheduler scheduler) {
            this.scheduler = Optional.of((Object)scheduler);
            return this;
        }

        public Builder action(Consumer<? super ErrorAndDuration> action) {
            this.action = action;
            return this;
        }

        public Builder exponentialBackoff(final long firstDelay, final TimeUnit unit, final double factor) {
            this.delays = Flowable.range((int)1, (int)Integer.MAX_VALUE).map((Function)new Function<Integer, Long>(){

                public Long apply(Integer n) {
                    return Math.round(Math.pow(factor, n - 1) * (double)unit.toMillis(firstDelay));
                }
            });
            return this;
        }

        public Builder exponentialBackoff(long firstDelay, TimeUnit unit) {
            return this.exponentialBackoff(firstDelay, unit, 2.0);
        }

        public Function<Flowable<? extends Throwable>, Flowable<Object>> build() {
            Preconditions.checkNotNull(this.delays);
            if (this.maxRetries.isPresent()) {
                this.delays = this.delays.take((long)((Integer)this.maxRetries.get()).intValue());
            }
            return RetryWhen.notificationHandler((Flowable<Long>)this.delays, (Scheduler)this.scheduler.get(), (Consumer<? super ErrorAndDuration>)this.action, this.retryExceptions, this.failExceptions, (Predicate<? super Throwable>)this.exceptionPredicate);
        }

        private static class ToLongHolder {
            static final Function<Integer, Long> INSTANCE = new Function<Integer, Long>(){

                public Long apply(Integer n) {
                    if (n == null) {
                        return null;
                    }
                    return n.longValue();
                }
            };

            private ToLongHolder() {
            }
        }
    }
}

