/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2;

import com.github.davidmoten.rx2.Callables;
import com.github.davidmoten.rx2.FlowableTransformers;
import io.reactivex.BackpressureStrategy;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableTransformer;
import io.reactivex.functions.BiPredicate;
import io.reactivex.functions.Function3;
import java.util.concurrent.Callable;

public final class StateMachine {
    private StateMachine() {
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class CompletionAlwaysTrueHolder {
        private static final Completion<Object, Object> INSTANCE = new Completion<Object, Object>(){

            @Override
            public boolean test(Object t1, FlowableEmitter<Object> t2) {
                return true;
            }
        };

        private CompletionAlwaysTrueHolder() {
        }

        static <State, Out> Completion<State, Out> instance() {
            return INSTANCE;
        }
    }

    public static final class Builder3<State, In, Out> {
        private static final int DEFAULT_REQUEST_SIZE = 1;
        private final Callable<State> initialState;
        private final Transition<State, In, Out> transition;
        private Completion<State, Out> completion = CompletionAlwaysTrueHolder.instance();
        private BackpressureStrategy backpressureStrategy = BackpressureStrategy.BUFFER;
        private int requestBatchSize = 1;

        private Builder3(Callable<State> initialState, Transition<State, In, Out> transition) {
            this.initialState = initialState;
            this.transition = transition;
        }

        public Builder3<State, In, Out> completion(Completion<State, Out> completion) {
            this.completion = completion;
            return this;
        }

        public Builder3<State, In, Out> backpressureStrategy(BackpressureStrategy backpressureStrategy) {
            this.backpressureStrategy = backpressureStrategy;
            return this;
        }

        public Builder3<State, In, Out> requestBatchSize(int value) {
            this.requestBatchSize = value;
            return this;
        }

        public FlowableTransformer<In, Out> build() {
            return FlowableTransformers.stateMachine(this.initialState, this.transition, this.completion, this.backpressureStrategy, this.requestBatchSize);
        }
    }

    public static final class Builder2<State> {
        private final Callable<State> initialState;

        private Builder2(Callable<State> initialState) {
            this.initialState = initialState;
        }

        public <In, Out> Builder3<State, In, Out> transition(Transition<State, In, Out> transition) {
            return new Builder3(this.initialState, transition);
        }
    }

    public static final class Builder {
        private Builder() {
        }

        public <State> Builder2<State> initialStateFactory(Callable<State> initialState) {
            return new Builder2(initialState);
        }

        public <State> Builder2<State> initialState(State initialState) {
            return this.initialStateFactory(Callables.constant(initialState));
        }
    }

    public static interface Completion<State, Out>
    extends BiPredicate<State, FlowableEmitter<Out>> {
        public boolean test(State var1, FlowableEmitter<Out> var2);
    }

    public static interface Transition<State, In, Out>
    extends Function3<State, In, FlowableEmitter<Out>, State> {
        public State apply(State var1, In var2, FlowableEmitter<Out> var3);
    }
}

