/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2;

import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.rx2.internal.flowable.FlowableStringSplitSimple;
import com.github.davidmoten.rx2.internal.flowable.TransformerDecode;
import com.github.davidmoten.rx2.internal.flowable.TransformerStringSplit;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Emitter;
import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.Maybe;
import io.reactivex.annotations.Beta;
import io.reactivex.annotations.Experimental;
import io.reactivex.functions.BiConsumer;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.reactivestreams.Publisher;

public final class Strings {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final int DEFAULT_REQUEST_SIZE = 1;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    static Function<Object, String> TRIM = new Function<Object, String>(){

        public String apply(Object input) throws Exception {
            if (input == null) {
                return null;
            }
            return input.toString().trim();
        }
    };

    private Strings() {
    }

    public static <T> Function<T, String> trim() {
        return TRIM;
    }

    public static Flowable<String> from(final Reader reader, final int bufferSize) {
        return Flowable.generate((Consumer)new Consumer<Emitter<String>>(){
            final char[] buffer;
            {
                this.buffer = new char[bufferSize];
            }

            public void accept(Emitter<String> emitter) throws Exception {
                int count = reader.read(this.buffer);
                if (count == -1) {
                    emitter.onComplete();
                } else {
                    emitter.onNext((Object)String.valueOf(this.buffer, 0, count));
                }
            }
        });
    }

    public static Flowable<String> from(Reader reader) {
        return Strings.from(reader, 8192);
    }

    public static Flowable<String> from(InputStream is) {
        return Strings.from(is, UTF_8);
    }

    public static Flowable<String> from(InputStream is, Charset charset) {
        return Strings.from(is, charset, 8192);
    }

    public static Flowable<String> from(InputStream is, Charset charset, int bufferSize) {
        return Strings.from(new InputStreamReader(is, charset), bufferSize);
    }

    public static Flowable<String> split(Flowable<String> source, String pattern) {
        return source.compose(Strings.split(pattern, BackpressureStrategy.BUFFER, 1));
    }

    public static Maybe<String> concat(Flowable<String> source) {
        return Strings.concat(source, "");
    }

    public static Maybe<String> concat(Flowable<String> source, String delimiter) {
        return Strings.join(source, delimiter);
    }

    public static Flowable<String> strings(Flowable<?> source) {
        return source.map((Function)new Function<Object, String>(){

            public String apply(Object t) throws Exception {
                return String.valueOf(t);
            }
        });
    }

    public static Flowable<String> from(File file) {
        return Strings.from(file, UTF_8);
    }

    public static Flowable<String> from(final File file, final Charset charset) {
        Preconditions.checkNotNull((Object)file);
        Preconditions.checkNotNull((Object)charset);
        Callable<Reader> resourceFactory = new Callable<Reader>(){

            @Override
            public Reader call() throws FileNotFoundException {
                return new InputStreamReader((InputStream)new FileInputStream(file), charset);
            }
        };
        return Strings.from(resourceFactory);
    }

    public static Flowable<String> fromClasspath(final Class<?> cls, final String resource, final Charset charset) {
        Preconditions.checkNotNull((Object)resource);
        Preconditions.checkNotNull((Object)charset);
        Callable<Reader> resourceFactory = new Callable<Reader>(){

            @Override
            public Reader call() {
                return new InputStreamReader(cls.getResourceAsStream(resource), charset);
            }
        };
        return Strings.from(resourceFactory);
    }

    public static Flowable<String> fromClasspath(String resource, Charset charset) {
        return Strings.fromClasspath(Strings.class, resource, charset);
    }

    public static Flowable<String> fromClasspath(String resource) {
        return Strings.fromClasspath(resource, Utf8Holder.INSTANCE);
    }

    public static Flowable<String> from(Callable<Reader> readerFactory) {
        Function<Reader, Flowable<String>> flowableFactory = new Function<Reader, Flowable<String>>(){

            public Flowable<String> apply(Reader reader) {
                return Strings.from(reader);
            }
        };
        return Flowable.using(readerFactory, (Function)flowableFactory, DisposeActionHolder.INSTANCE, (boolean)true);
    }

    public static Maybe<String> join(Flowable<String> source) {
        return Strings.join(source, "");
    }

    public static FlowableTransformer<byte[], String> decode(CharsetDecoder decoder) {
        return Strings.decode(decoder, BackpressureStrategy.BUFFER, 1);
    }

    public static FlowableTransformer<byte[], String> decode(CharsetDecoder decoder, BackpressureStrategy backpressureStrategy, int requestBatchSize) {
        return TransformerDecode.decode(decoder, BackpressureStrategy.BUFFER, requestBatchSize);
    }

    public static Flowable<String> decode(Flowable<byte[]> source, CharsetDecoder decoder) {
        return source.compose(Strings.decode(decoder));
    }

    public static Flowable<String> decode(Flowable<byte[]> source, Charset charset) {
        return Strings.decode(source, charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE));
    }

    public static Flowable<String> decode(Flowable<byte[]> source, String charset) {
        return Strings.decode(source, Charset.forName(charset));
    }

    public static Maybe<String> join(final Flowable<String> source, final String delimiter) {
        return Maybe.defer((Callable)new Callable<Maybe<String>>(){
            final AtomicBoolean afterFirst = new AtomicBoolean(false);
            final AtomicBoolean isEmpty = new AtomicBoolean(true);

            @Override
            public Maybe<String> call() {
                return source.collect((Callable)new Callable<StringBuilder>(){

                    @Override
                    public StringBuilder call() {
                        return new StringBuilder();
                    }
                }, (BiConsumer)new BiConsumer<StringBuilder, String>(){

                    public void accept(StringBuilder b, String s) throws Exception {
                        if (!afterFirst.compareAndSet(false, true)) {
                            b.append(delimiter);
                        }
                        b.append(s);
                        isEmpty.set(false);
                    }
                }).flatMapMaybe((Function)new Function<StringBuilder, Maybe<String>>(){

                    public Maybe<String> apply(StringBuilder b) {
                        if (isEmpty.get()) {
                            return Maybe.empty();
                        }
                        return Maybe.just((Object)b.toString());
                    }
                });
            }
        });
    }

    public static Flowable<List<String>> splitLinesSkipComments(InputStream is, Charset charset, final String delimiter, final String commentPrefix) {
        return Strings.from(is, charset).compose(Strings.split("\n", BackpressureStrategy.BUFFER, 1)).filter((Predicate)new Predicate<String>(){

            public boolean test(String line) {
                return !line.startsWith(commentPrefix);
            }
        }).map(SplitLinesHolder.trim).filter(SplitLinesHolder.notEmpty).map((Function)new Function<String, List<String>>(){

            public List<String> apply(String line) {
                return Arrays.asList(line.split(delimiter));
            }
        });
    }

    public static FlowableTransformer<String, String> split(String pattern) {
        return Strings.split(pattern, BackpressureStrategy.BUFFER, 128);
    }

    public static FlowableTransformer<String, String> split(Pattern pattern) {
        return Strings.split(pattern, BackpressureStrategy.BUFFER, 128);
    }

    public static FlowableTransformer<String, String> split(String pattern, BackpressureStrategy backpressureStrategy, int requestBatchSize) {
        return TransformerStringSplit.split(pattern, null, backpressureStrategy, requestBatchSize);
    }

    public static FlowableTransformer<String, String> split(Pattern pattern, BackpressureStrategy backpressureStrategy, int batchSize) {
        return TransformerStringSplit.split(null, pattern, backpressureStrategy, batchSize);
    }

    public static Function<Flowable<String>, Maybe<String>> join(final String delimiter) {
        return new Function<Flowable<String>, Maybe<String>>(){

            public Maybe<String> apply(Flowable<String> source) throws Exception {
                return Strings.join(source, delimiter);
            }
        };
    }

    public static Function<Flowable<String>, Maybe<String>> join() {
        return Strings.join("");
    }

    public static Function<Flowable<String>, Maybe<String>> concat(String delimiter) {
        return Strings.join(delimiter);
    }

    public static Function<Flowable<String>, Maybe<String>> concat() {
        return Strings.concat("");
    }

    public static <T> FlowableTransformer<T, String> strings() {
        return new FlowableTransformer<T, String>(){

            public Publisher<String> apply(Flowable<T> source) {
                return Strings.strings(source);
            }
        };
    }

    @Experimental
    @Beta
    public static <T> FlowableTransformer<String, String> splitSimple(final String delimiter) {
        return new FlowableTransformer<String, String>(){

            public Publisher<String> apply(Flowable<String> source) {
                return new FlowableStringSplitSimple(source, delimiter);
            }
        };
    }

    private static class SplitLinesHolder {
        static final Function<String, String> trim = new Function<String, String>(){

            public String apply(String line) {
                return line.trim();
            }
        };
        static final Predicate<String> notEmpty = new Predicate<String>(){

            public boolean test(String line) {
                return !line.isEmpty();
            }
        };

        private SplitLinesHolder() {
        }
    }

    private static class DisposeActionHolder {
        static final Consumer<Reader> INSTANCE = new Consumer<Reader>(){

            public void accept(Reader reader) throws IOException {
                reader.close();
            }
        };

        private DisposeActionHolder() {
        }
    }

    private static class Utf8Holder {
        static final Charset INSTANCE = Charset.forName("UTF-8");

        private Utf8Holder() {
        }
    }
}

