/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2.buffertofile;

import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.rx2.buffertofile.DataSerializer;
import com.github.davidmoten.rx2.buffertofile.Serializer;
import com.github.davidmoten.rx2.buffertofile.Serializers;
import com.github.davidmoten.rx2.internal.flowable.buffertofile.FlowableOnBackpressureBufferToFile;
import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.Callable;
import org.reactivestreams.Publisher;

public final class Options {
    public static final String DEFAULT_FILE_PREFIX = "bufferToFile_";
    private final Callable<File> fileFactory;
    private final int pageSizeBytes;
    private final Scheduler scheduler;

    private Options(Callable<File> filefactory, int pageSizeBytes, Scheduler scheduler) {
        Preconditions.checkNotNull(filefactory);
        Preconditions.checkArgument((pageSizeBytes > 0 ? 1 : 0) != 0, (String)"bufferSizeBytes must be greater than 0");
        Preconditions.checkNotNull((Object)scheduler);
        this.fileFactory = filefactory;
        this.pageSizeBytes = pageSizeBytes;
        this.scheduler = scheduler;
    }

    public Callable<File> fileFactory() {
        return this.fileFactory;
    }

    public int pageSizeBytes() {
        return this.pageSizeBytes;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public static BuilderFlowable builderFlowable() {
        return new BuilderFlowable();
    }

    public static BuilderObservable builderObservable() {
        return new BuilderObservable();
    }

    private static final class FileFactoryHolder {
        private static final Callable<File> INSTANCE = new Callable<File>(){

            @Override
            public File call() {
                try {
                    return File.createTempFile(Options.DEFAULT_FILE_PREFIX, ".obj");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };

        private FileFactoryHolder() {
        }

        static /* synthetic */ Callable access$000() {
            return INSTANCE;
        }
    }

    public static final class BuilderObservable {
        private Callable<File> fileFactory = FileFactoryHolder.access$000();
        private int pageSizeBytes = 0x100000;
        private Scheduler scheduler = Schedulers.io();

        BuilderObservable() {
        }

        public BuilderObservable pageSizeBytes(int pageSizeBytes) {
            this.pageSizeBytes = pageSizeBytes;
            return this;
        }

        public BuilderObservable scheduler(Scheduler scheduler) {
            this.scheduler = scheduler;
            return this;
        }

        public BuilderObservable fileFactory(Callable<File> fileFactory) {
            this.fileFactory = fileFactory;
            return this;
        }

        public <T extends Serializable> Function<Observable<T>, Flowable<T>> serializerJavaIO() {
            return this.serializer(Serializers.javaIO());
        }

        public Function<Observable<byte[]>, Flowable<byte[]>> serializerBytes() {
            return this.serializer(Serializers.bytes());
        }

        public Function<Observable<String>, Flowable<String>> serializerUtf8() {
            return this.serializer(Serializers.utf8());
        }

        public <T> Function<Observable<T>, Flowable<T>> serializer(final Serializer<T> serializer) {
            final Options options = new Options(this.fileFactory, this.pageSizeBytes, this.scheduler);
            return new Function<Observable<T>, Flowable<T>>(){

                public Flowable<T> apply(Observable<T> source) {
                    return new FlowableOnBackpressureBufferToFile(null, source, options, serializer);
                }
            };
        }

        public <T> Function<Observable<T>, Flowable<T>> serializer(DataSerializer<T> ds) {
            return this.serializer(Serializers.from(ds));
        }
    }

    public static final class BuilderFlowable {
        private Callable<File> fileFactory = FileFactoryHolder.access$000();
        private int pageSizeBytes = 0x100000;
        private Scheduler scheduler = Schedulers.io();

        BuilderFlowable() {
        }

        public BuilderFlowable pageSizeBytes(int pageSizeBytes) {
            this.pageSizeBytes = pageSizeBytes;
            return this;
        }

        public BuilderFlowable scheduler(Scheduler scheduler) {
            this.scheduler = scheduler;
            return this;
        }

        public BuilderFlowable fileFactory(Callable<File> fileFactory) {
            this.fileFactory = fileFactory;
            return this;
        }

        public <T extends Serializable> FlowableTransformer<T, T> serializerJavaIO() {
            return this.serializer(Serializers.javaIO());
        }

        public FlowableTransformer<byte[], byte[]> serializerBytes() {
            return this.serializer(Serializers.bytes());
        }

        public FlowableTransformer<String, String> serializerUtf8() {
            return this.serializer(Serializers.utf8());
        }

        public <T> FlowableTransformer<T, T> serializer(final Serializer<T> serializer) {
            final Options options = new Options(this.fileFactory, this.pageSizeBytes, this.scheduler);
            return new FlowableTransformer<T, T>(){

                public Publisher<T> apply(Flowable<T> source) {
                    return new FlowableOnBackpressureBufferToFile(source, null, options, serializer);
                }
            };
        }

        public <T> FlowableTransformer<T, T> serializer(DataSerializer<T> ds) {
            return this.serializer(Serializers.from(ds));
        }
    }
}

