/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2.internal.flowable;

import com.github.davidmoten.rx2.FlowableTransformers;
import io.reactivex.BackpressureStrategy;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableTransformer;
import io.reactivex.functions.BiPredicate;
import io.reactivex.functions.Function3;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.concurrent.Callable;

public final class TransformerDecode {
    private TransformerDecode() {
    }

    public static FlowableTransformer<byte[], String> decode(final CharsetDecoder decoder, BackpressureStrategy backpressureStrategy, int batchSize) {
        Callable<ByteBuffer> initialState = new Callable<ByteBuffer>(){

            @Override
            public ByteBuffer call() {
                return null;
            }
        };
        Function3<ByteBuffer, byte[], FlowableEmitter<String>, ByteBuffer> transition = new Function3<ByteBuffer, byte[], FlowableEmitter<String>, ByteBuffer>(){

            public ByteBuffer apply(ByteBuffer last, byte[] next, FlowableEmitter<String> o) {
                Result result = TransformerDecode.process(next, last, false, decoder, o);
                return result.leftOver;
            }
        };
        BiPredicate<ByteBuffer, FlowableEmitter<String>> completion = new BiPredicate<ByteBuffer, FlowableEmitter<String>>(){

            public boolean test(ByteBuffer last, FlowableEmitter<String> subscriber) {
                return TransformerDecode.process(null, (ByteBuffer)last, (boolean)true, (CharsetDecoder)decoder, subscriber).canEmitFurther;
            }
        };
        return FlowableTransformers.stateMachine(initialState, transition, completion, backpressureStrategy, batchSize);
    }

    public static Result process(byte[] next, ByteBuffer last, boolean endOfInput, CharsetDecoder decoder, FlowableEmitter<String> emitter) {
        ByteBuffer bb;
        if (emitter.isCancelled()) {
            return new Result(null, false);
        }
        if (last != null) {
            if (next != null) {
                bb = ByteBuffer.allocate(last.remaining() + next.length);
                bb.put(last);
                bb.put(next);
                bb.flip();
            } else {
                bb = last;
            }
        } else if (next != null) {
            bb = ByteBuffer.wrap(next);
        } else {
            return new Result(null, true);
        }
        CharBuffer cb = CharBuffer.allocate((int)((float)bb.limit() * decoder.averageCharsPerByte()));
        CoderResult cr = decoder.decode(bb, cb, endOfInput);
        cb.flip();
        if (cr.isError()) {
            try {
                cr.throwException();
            }
            catch (CharacterCodingException e) {
                emitter.onError((Throwable)e);
                return new Result(null, false);
            }
        }
        ByteBuffer leftOver = bb.remaining() > 0 ? bb : null;
        String string = cb.toString();
        if (!string.isEmpty()) {
            emitter.onNext((Object)string);
        }
        return new Result(leftOver, true);
    }

    private static final class Result {
        final ByteBuffer leftOver;
        final boolean canEmitFurther;

        Result(ByteBuffer leftOver, boolean canEmitFurther) {
            this.leftOver = leftOver;
            this.canEmitFurther = canEmitFurther;
        }
    }
}

