/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2.internal.flowable;

import com.github.davidmoten.rx2.Callables;
import com.github.davidmoten.rx2.FlowableTransformers;
import io.reactivex.BackpressureStrategy;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableTransformer;
import io.reactivex.functions.BiPredicate;
import io.reactivex.functions.Function3;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;

public final class TransformerStringSplit {
    private TransformerStringSplit() {
    }

    public static <T> FlowableTransformer<String, String> split(final String pattern, final Pattern compiledPattern, BackpressureStrategy backpressureStrategy, int batchSize) {
        Callable<Object> initialState = Callables.constant(null);
        Function3<String, String, FlowableEmitter<String>, String> transition = new Function3<String, String, FlowableEmitter<String>, String>(){

            public String apply(String leftOver, String s, FlowableEmitter<String> emitter) {
                if (leftOver != null) {
                    s = leftOver + s;
                }
                String[] parts = compiledPattern != null ? compiledPattern.split(s, -1) : s.split(pattern, -1);
                for (int i = 0; i < parts.length - 1; ++i) {
                    if (emitter.isCancelled()) {
                        return null;
                    }
                    emitter.onNext((Object)parts[i]);
                }
                return parts[parts.length - 1];
            }
        };
        BiPredicate<String, FlowableEmitter<String>> completion = new BiPredicate<String, FlowableEmitter<String>>(){

            public boolean test(String leftOver, FlowableEmitter<String> emitter) {
                if (leftOver != null && !emitter.isCancelled()) {
                    emitter.onNext((Object)leftOver);
                }
                if (!emitter.isCancelled()) {
                    emitter.onComplete();
                }
                return true;
            }
        };
        return FlowableTransformers.stateMachine(initialState, transition, completion, backpressureStrategy, batchSize);
    }
}

