/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2.internal.flowable.buffertofile;

import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.rx2.internal.flowable.buffertofile.Page;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import java.io.File;
import java.util.concurrent.Callable;

public final class Pages {
    private static final boolean CHECK = false;
    private static final int QUEUE_INITIAL_CAPACITY = 16;
    private static final byte[] EMPTY = new byte[0];
    private final Callable<File> fileFactory;
    private final int pageSize;
    private final SimplePlainQueue<Page> queue = new SpscLinkedArrayQueue(16);
    Page writePage;
    int writePosition;
    Page readPage;
    int readPosition;
    Page markPage;
    int markPosition;

    public Pages(Callable<File> fileFactory, int pageSize) {
        Preconditions.checkArgument((pageSize >= 4 ? 1 : 0) != 0);
        Preconditions.checkArgument((pageSize % 4 == 0 ? 1 : 0) != 0);
        this.fileFactory = fileFactory;
        this.pageSize = pageSize;
    }

    public int avail() {
        return this.writePage().avail(this.writePosition);
    }

    public void markForRewriteAndAdvance4Bytes() {
        this.markPage = this.writePage();
        this.markPosition = this.writePosition;
        this.writePosition += 4;
    }

    public void putInt(int value) {
        this.putInt(this.writePage(), value);
    }

    private void putInt(Page page, int value) {
        page.putInt(this.writePosition, value);
        this.writePosition += 4;
    }

    public void put(byte[] bytes, int offset, int length) {
        Page page = this.writePage();
        page.put(this.writePosition, bytes, offset, length);
        this.writePosition += length;
    }

    public void putIntOrderedAtRewriteMark(int value) {
        this.markPage.putIntOrdered(this.markPosition, value);
        this.markPage = null;
    }

    private Page writePage() {
        if (this.writePage == null || this.writePosition == this.pageSize) {
            this.createNewPage();
        }
        return this.writePage;
    }

    private void createNewPage() {
        File file;
        try {
            file = this.fileFactory.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.writePage = new Page(file, this.pageSize);
        this.writePosition = 0;
        this.queue.offer((Object)this.writePage);
    }

    public int getInt() {
        if (this.readPage() == null) {
            return -1;
        }
        int rp = this.readPosition;
        this.readPosition = rp + 4;
        return this.readPage.getInt(rp);
    }

    public byte[] get(int length) {
        byte[] result = new byte[length];
        if (this.readPage() == null) {
            return EMPTY;
        }
        this.readPage.get(result, 0, this.readPosition, length);
        this.readPosition += length;
        return result;
    }

    private Page readPage() {
        if (this.readPage == null || this.readPosition >= this.pageSize) {
            if (this.readPage != null) {
                this.readPage.close();
            }
            this.readPage = (Page)this.queue.poll();
            this.readPosition %= this.pageSize;
        }
        return this.readPage;
    }

    public void putByte(byte b) {
        Page page = this.writePage();
        page.putByte(this.writePosition, b);
        ++this.writePosition;
    }

    public byte getByte() {
        Page page = this.readPage();
        byte result = page.getByte(this.readPosition);
        ++this.readPosition;
        return result;
    }

    public void moveReadPosition(int forward) {
        this.readPosition += forward;
    }

    public int getIntVolatile() {
        if (this.readPage() == null) {
            return -1;
        }
        int result = this.readPage.getIntVolatile(this.readPosition);
        this.readPosition += 4;
        return result;
    }

    public void moveWritePosition(int forward) {
        this.writePosition += forward;
    }

    public void close() {
        Page page;
        if (this.readPage != null) {
            this.readPage.close();
            this.readPage = null;
        }
        while ((page = (Page)this.queue.poll()) != null) {
            page.close();
        }
    }
}

