/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2;

import com.github.davidmoten.rx2.exceptions.ThrowingException;
import io.reactivex.functions.Function;

public final class Functions {
    private Functions() {
    }

    public static <T> Function<Object, T> constant(final T value) {
        return new Function<Object, T>(){

            public T apply(Object t) throws Exception {
                return value;
            }
        };
    }

    public static <T> Function<T, T> identity() {
        return IdentityHolder.INSTANCE;
    }

    public static <T, R> Function<T, R> throwing() {
        return new Function<T, R>(){

            public R apply(T t) {
                throw new ThrowingException();
            }
        };
    }

    private static final class IdentityHolder {
        static final Function<Object, Object> INSTANCE = new Function<Object, Object>(){

            public Object apply(Object t) throws Exception {
                return t;
            }
        };

        private IdentityHolder() {
        }
    }
}

