/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2.internal.flowable;

import com.github.davidmoten.guavamini.Preconditions;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Action;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableDoOnEmpty<T>
extends Flowable<T> {
    private final Publisher<T> source;
    private final Action onEmpty;

    public FlowableDoOnEmpty(Publisher<T> source, Action onEmpty) {
        Preconditions.checkNotNull(source, (String)"source cannot be null");
        Preconditions.checkNotNull((Object)onEmpty, (String)"onEmpty cannot be null");
        this.source = source;
        this.onEmpty = onEmpty;
    }

    protected void subscribeActual(Subscriber<? super T> child) {
        this.source.subscribe(new DoOnEmptySubscriber<T>(child, this.onEmpty));
    }

    private static final class DoOnEmptySubscriber<T>
    implements FlowableSubscriber<T>,
    Subscription {
        private final Subscriber<? super T> child;
        private final Action onEmpty;
        private boolean done;
        private boolean empty = true;
        private Subscription parent;

        DoOnEmptySubscriber(Subscriber<? super T> child, Action onEmpty) {
            this.child = child;
            this.onEmpty = onEmpty;
        }

        public void onSubscribe(Subscription parent) {
            if (SubscriptionHelper.validate((Subscription)this.parent, (Subscription)parent)) {
                this.parent = parent;
                this.child.onSubscribe((Subscription)this);
            }
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            if (this.empty) {
                try {
                    this.onEmpty.run();
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal((Throwable)e);
                    this.onError(e);
                    return;
                }
            }
            this.done = true;
            this.child.onComplete();
        }

        public void onNext(T t) {
            this.empty = false;
            this.child.onNext(t);
        }

        public void onError(Throwable e) {
            if (this.done) {
                return;
            }
            this.done = true;
            this.child.onError(e);
        }

        public void cancel() {
            this.parent.cancel();
        }

        public void request(long n) {
            this.parent.request(n);
        }
    }
}

