/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2.internal.flowable;

import com.github.davidmoten.guavamini.Preconditions;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Function;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableMatch<A, B, K, C>
extends Flowable<C> {
    private final Flowable<A> a;
    private final Flowable<B> b;
    private final Function<? super A, ? extends K> aKey;
    private final Function<? super B, ? extends K> bKey;
    private final BiFunction<? super A, ? super B, C> combiner;
    private final long requestSize;

    public FlowableMatch(Flowable<A> a, Flowable<B> b, Function<? super A, ? extends K> aKey, Function<? super B, ? extends K> bKey, BiFunction<? super A, ? super B, C> combiner, long requestSize) {
        Preconditions.checkNotNull(a, (String)"a should not be null");
        Preconditions.checkNotNull(b, (String)"b should not be null");
        Preconditions.checkNotNull(aKey, (String)"aKey cannot be null");
        Preconditions.checkNotNull(bKey, (String)"bKey cannot be null");
        Preconditions.checkNotNull(combiner, (String)"combiner cannot be null");
        Preconditions.checkArgument((requestSize >= 1L ? 1 : 0) != 0, (String)"requestSize must be >=1");
        this.a = a;
        this.b = b;
        this.aKey = aKey;
        this.bKey = bKey;
        this.combiner = combiner;
        this.requestSize = requestSize;
    }

    protected void subscribeActual(Subscriber<? super C> child) {
        MatchCoordinator<A, B, K, C> coordinator = new MatchCoordinator<A, B, K, C>(this.aKey, this.bKey, this.combiner, this.requestSize, child);
        child.onSubscribe(coordinator);
        coordinator.subscribe(this.a, this.b);
    }

    private static enum Source {
        A,
        B;

    }

    private static final class ItemA {
        final Object value;

        ItemA(Object value) {
            this.value = value;
        }
    }

    private static final class MyError {
        final Throwable error;

        MyError(Throwable error) {
            this.error = error;
        }
    }

    private static final class MySubscriber<T, K>
    extends AtomicReference<Subscription>
    implements FlowableSubscriber<T>,
    Subscription {
        private final Receiver receiver;
        private final Source source;
        private final long requestSize;

        MySubscriber(Source source, Receiver receiver, long requestSize) {
            this.source = source;
            this.receiver = receiver;
            this.requestSize = requestSize;
        }

        public void onSubscribe(Subscription subscription) {
            if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)subscription)) {
                subscription.request(this.requestSize);
            }
        }

        public void request(long n) {
            ((Subscription)this.get()).request(n);
        }

        public void cancel() {
            SubscriptionHelper.cancel((AtomicReference)this);
        }

        public void onNext(T t) {
            if (this.source == Source.A) {
                this.receiver.offer(new ItemA(t));
            } else {
                this.receiver.offer(t);
            }
        }

        public void onComplete() {
            this.receiver.offer((Object)this.source);
        }

        public void onError(Throwable e) {
            this.receiver.offer(new MyError(e));
        }
    }

    private static final class MatchCoordinator<A, B, K, C>
    extends AtomicInteger
    implements Receiver,
    Subscription {
        private final Map<K, Queue<A>> as = new HashMap<K, Queue<A>>();
        private final Map<K, Queue<B>> bs = new HashMap<K, Queue<B>>();
        private final Function<? super A, ? extends K> aKey;
        private final Function<? super B, ? extends K> bKey;
        private final BiFunction<? super A, ? super B, C> combiner;
        private final long requestSize;
        private final transient SimpleQueue<Object> queue;
        private final Subscriber<? super C> child;
        private final AtomicLong requested = new AtomicLong(0L);
        private int requestFromA = 0;
        private int requestFromB = 0;
        private int completed = 0;
        private static final int COMPLETED_NONE = 0;
        private static final int COMPLETED_A = 1;
        private static final int COMPLETED_B = 2;
        private static final int COMPLETED_BOTH = 3;
        private MySubscriber<A, K> aSub;
        private MySubscriber<B, K> bSub;
        private volatile boolean cancelled = false;

        MatchCoordinator(Function<? super A, ? extends K> aKey, Function<? super B, ? extends K> bKey, BiFunction<? super A, ? super B, C> combiner, long requestSize, Subscriber<? super C> child) {
            this.aKey = aKey;
            this.bKey = bKey;
            this.combiner = combiner;
            this.requestSize = requestSize;
            this.queue = new MpscLinkedQueue();
            this.child = child;
        }

        public void subscribe(Flowable<A> a, Flowable<B> b) {
            this.aSub = new MySubscriber(Source.A, this, this.requestSize);
            this.bSub = new MySubscriber(Source.B, this, this.requestSize);
            a.subscribe(this.aSub);
            b.subscribe(this.bSub);
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                BackpressureHelper.add((AtomicLong)this.requested, (long)n);
                this.drain();
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.cancelAll();
            }
        }

        void cancelAll() {
            this.aSub.cancel();
            this.bSub.cancel();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            do {
                long r = this.requested.get();
                long emitted = 0L;
                while (emitted != r) {
                    Emitted em;
                    Object v;
                    if (this.cancelled) {
                        return;
                    }
                    try {
                        v = this.queue.poll();
                    }
                    catch (Exception e) {
                        Exceptions.throwIfFatal((Throwable)e);
                        this.clear();
                        this.child.onError((Throwable)e);
                        return;
                    }
                    if (v == null) break;
                    if (v instanceof ItemA) {
                        em = this.handleItem(((ItemA)v).value, Source.A);
                        if (em == Emitted.FINISHED) {
                            return;
                        }
                        if (em == Emitted.ONE) {
                            ++emitted;
                        }
                    } else if (v instanceof Source) {
                        Status status = this.handleCompleted((Source)((Object)v));
                        if (status == Status.FINISHED) {
                            return;
                        }
                    } else {
                        if (v instanceof MyError) {
                            this.clear();
                            this.child.onError(((MyError)v).error);
                            return;
                        }
                        em = this.handleItem(v, Source.B);
                        if (em == Emitted.FINISHED) {
                            return;
                        }
                        if (em == Emitted.ONE) {
                            ++emitted;
                        }
                    }
                    if (r != emitted) continue;
                    break;
                }
                BackpressureHelper.produced((AtomicLong)this.requested, (long)emitted);
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        private Emitted handleItem(Object value, Source source) {
            Emitted result;
            if (source == Source.A) {
                Object key;
                Object a = value;
                try {
                    key = this.aKey.apply(a);
                }
                catch (Throwable e) {
                    this.clear();
                    this.child.onError(e);
                    return Emitted.FINISHED;
                }
                Queue<B> q = this.bs.get(key);
                if (q == null) {
                    MatchCoordinator.add(this.as, key, a);
                    result = Emitted.NONE;
                } else {
                    Object c;
                    B b = MatchCoordinator.poll(this.bs, q, key);
                    try {
                        c = this.combiner.apply(a, b);
                    }
                    catch (Throwable e) {
                        this.clear();
                        this.child.onError(e);
                        return Emitted.FINISHED;
                    }
                    this.child.onNext(c);
                    result = Emitted.ONE;
                }
                if (this.completed == 2 && this.bs.isEmpty()) {
                    this.clear();
                    this.child.onComplete();
                    return Emitted.FINISHED;
                }
                ++this.requestFromA;
            } else {
                Object key;
                Object b = value;
                try {
                    key = this.bKey.apply(b);
                }
                catch (Throwable e) {
                    this.clear();
                    this.child.onError(e);
                    return Emitted.FINISHED;
                }
                Queue<A> q = this.as.get(key);
                if (q == null) {
                    MatchCoordinator.add(this.bs, key, b);
                    result = Emitted.NONE;
                } else {
                    Object c;
                    A a = MatchCoordinator.poll(this.as, q, key);
                    try {
                        c = this.combiner.apply(a, b);
                    }
                    catch (Throwable e) {
                        this.clear();
                        this.child.onError(e);
                        return Emitted.FINISHED;
                    }
                    this.child.onNext(c);
                    result = Emitted.ONE;
                }
                if (this.completed == 1 && this.as.isEmpty()) {
                    this.clear();
                    this.child.onComplete();
                    return Emitted.FINISHED;
                }
                ++this.requestFromB;
            }
            this.checkToRequestMore();
            return result;
        }

        private Status handleCompleted(Source source) {
            boolean done;
            this.completed(source);
            if (source == Source.A) {
                this.aSub.cancel();
                done = this.completed == 3 || this.completed == 1 && this.as.isEmpty();
            } else {
                this.bSub.cancel();
                boolean bl = done = this.completed == 3 || this.completed == 2 && this.bs.isEmpty();
            }
            if (done) {
                this.clear();
                this.child.onComplete();
                return Status.FINISHED;
            }
            this.checkToRequestMore();
            return Status.KEEP_GOING;
        }

        private void checkToRequestMore() {
            if ((long)this.requestFromA == this.requestSize && this.completed == 2) {
                this.requestFromA = 0;
                this.aSub.request(this.requestSize);
            } else if ((long)this.requestFromB == this.requestSize && this.completed == 1) {
                this.requestFromB = 0;
                this.bSub.request(this.requestSize);
            } else if ((long)this.requestFromA == this.requestSize && (long)this.requestFromB == this.requestSize) {
                this.requestFromA = 0;
                this.requestFromB = 0;
                this.aSub.request(this.requestSize);
                this.bSub.request(this.requestSize);
            }
        }

        private void completed(Source source) {
            if (source == Source.A) {
                if (this.completed == 0) {
                    this.completed = 1;
                } else if (this.completed == 2) {
                    this.completed = 3;
                }
            } else if (this.completed == 0) {
                this.completed = 2;
            } else if (this.completed == 1) {
                this.completed = 3;
            }
        }

        private void clear() {
            this.as.clear();
            this.bs.clear();
            this.queue.clear();
            this.aSub.cancel();
            this.bSub.cancel();
        }

        private static <K, T> void add(Map<K, Queue<T>> map, K key, T value) {
            Queue<T> q = map.get(key);
            if (q == null) {
                q = new LinkedList<T>();
                map.put(key, q);
            }
            q.offer(value);
        }

        private static <K, T> T poll(Map<K, Queue<T>> map, Queue<T> q, K key) {
            T t = q.poll();
            if (q.isEmpty()) {
                map.remove(key);
            }
            return t;
        }

        @Override
        public void offer(Object item) {
            this.queue.offer(item);
            this.drain();
        }

        private static enum Status {
            FINISHED,
            KEEP_GOING;

        }

        private static enum Emitted {
            ONE,
            NONE,
            FINISHED;

        }
    }

    static interface Receiver {
        public void offer(Object var1);
    }
}

