/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2.internal.flowable;

import com.github.davidmoten.guavamini.Preconditions;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableMinRequest<T>
extends Flowable<T> {
    private final Flowable<T> source;
    private final int[] minRequest;

    public FlowableMinRequest(Flowable<T> source, int[] minRequests) {
        Preconditions.checkArgument((minRequests.length > 0 ? 1 : 0) != 0, (String)"minRequests length must be > 0");
        for (int i = 0; i < minRequests.length; ++i) {
            Preconditions.checkArgument((minRequests[i] > 0 ? 1 : 0) != 0, (String)"each item in minRequests must be > 0");
        }
        this.source = source;
        this.minRequest = minRequests;
    }

    protected void subscribeActual(Subscriber<? super T> child) {
        this.source.subscribe(new MinRequestSubscriber<T>(this.minRequest, child));
    }

    private static final class MinRequestSubscriber<T>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription {
        private final int[] minRequests;
        private int requestNum;
        private final Subscriber<? super T> child;
        private final AtomicLong requested = new AtomicLong();
        private final SimplePlainQueue<T> queue = new SpscLinkedArrayQueue(16);
        private Subscription parent;
        private volatile boolean done;
        private Throwable error;
        private volatile boolean cancelled;
        private long count;

        MinRequestSubscriber(int[] minRequests, Subscriber<? super T> child) {
            this.minRequests = minRequests;
            this.child = child;
        }

        public void onSubscribe(Subscription parent) {
            if (SubscriptionHelper.validate((Subscription)this.parent, (Subscription)parent)) {
                this.parent = parent;
                this.child.onSubscribe((Subscription)this);
            }
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                BackpressureHelper.add((AtomicLong)this.requested, (long)n);
                this.drain();
            }
        }

        public void cancel() {
            this.cancelled = true;
            this.parent.cancel();
        }

        public void onNext(T t) {
            this.queue.offer(t);
            this.drain();
        }

        public void onError(Throwable e) {
            this.error = e;
            this.done = true;
            this.drain();
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        private void drain() {
            if (this.getAndIncrement() == 0) {
                int missed = 1;
                do {
                    long r = this.requested.get();
                    long e = 0L;
                    boolean d = this.done;
                    while (e != r) {
                        if (this.cancelled) {
                            this.queue.clear();
                            return;
                        }
                        Object t = this.queue.poll();
                        if (t == null) {
                            if (!d) break;
                            this.terminate();
                            return;
                        }
                        this.child.onNext(t);
                        ++e;
                        if (this.count != Long.MAX_VALUE) {
                            --this.count;
                        }
                        d = this.done;
                    }
                    if (d && this.queue.isEmpty()) {
                        this.terminate();
                        return;
                    }
                    if (e != 0L && r != Long.MAX_VALUE) {
                        r = this.requested.addAndGet(-e);
                    }
                    if (r == 0L || this.count != 0L) continue;
                    int min = this.minRequests[this.requestNum];
                    if (this.requestNum != this.minRequests.length - 1) {
                        ++this.requestNum;
                    }
                    this.count = Math.max(r, (long)min);
                    this.parent.request(this.count);
                } while ((missed = this.addAndGet(-missed)) != 0);
                return;
            }
        }

        private void terminate() {
            this.parent.cancel();
            Throwable err = this.error;
            if (err != null) {
                this.error = null;
                this.child.onError(err);
            } else {
                this.child.onComplete();
            }
        }
    }
}

