/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2.internal.flowable;

import io.reactivex.Flowable;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableRepeat<T>
extends Flowable<T> {
    private final T value;
    private final long count;

    public FlowableRepeat(T value, long count) {
        this.value = value;
        this.count = count;
    }

    protected void subscribeActual(Subscriber<? super T> child) {
        RepeatSubscription<? super T> sub = new RepeatSubscription<T>(child, this.value, this.count);
        child.onSubscribe(sub);
    }

    private static class RepeatSubscription<T>
    extends AtomicLong
    implements Subscription {
        private final Subscriber<? super T> child;
        private final T value;
        private final long count;
        private volatile boolean cancelled;
        private long counter;

        RepeatSubscription(Subscriber<? super T> child, T value, long count) {
            this.child = child;
            this.value = value;
            this.count = count;
            this.counter = count;
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n) && BackpressureHelper.add((AtomicLong)this, (long)n) == 0L) {
                long requested = n;
                long emitted = 0L;
                do {
                    emitted = requested;
                    while (!(requested-- <= 0L || this.cancelled || this.count != -1L && this.counter-- <= 0L)) {
                        this.child.onNext(this.value);
                    }
                } while ((requested = this.addAndGet(-emitted)) > 0L);
                if (this.count >= 0L && !this.cancelled) {
                    this.child.onComplete();
                }
            }
        }

        public void cancel() {
            this.cancelled = true;
        }
    }
}

