/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2.internal.flowable;

import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import java.util.Iterator;
import java.util.List;

public final class FlowableReverse {
    private static final Function<List<Object>, Iterable<Object>> REVERSE_LIST = new Function<List<Object>, Iterable<Object>>(){

        public Iterable<Object> apply(List<Object> list) {
            return FlowableReverse.reverse(list);
        }
    };

    private FlowableReverse() {
    }

    public static <T> Flowable<T> reverse(Flowable<T> source) {
        return source.toList().toFlowable().flatMapIterable(REVERSE_LIST);
    }

    private static <T> Iterable<T> reverse(final List<T> list) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    int i;
                    {
                        this.i = list.size();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i > 0;
                    }

                    @Override
                    public T next() {
                        --this.i;
                        return list.get(this.i);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

