/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2.internal.flowable;

import com.github.davidmoten.guavamini.Preconditions;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import io.reactivex.FlowableTransformer;
import io.reactivex.Notification;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.BiPredicate;
import io.reactivex.functions.Cancellable;
import io.reactivex.functions.Function;
import io.reactivex.functions.Function3;
import io.reactivex.functions.Predicate;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;

public final class TransformerStateMachine<State, In, Out>
implements FlowableTransformer<In, Out> {
    private final Callable<? extends State> initialState;
    private final Function3<? super State, ? super In, ? super FlowableEmitter<Out>, ? extends State> transition;
    private final BiPredicate<? super State, ? super FlowableEmitter<Out>> completion;
    private final BackpressureStrategy backpressureStrategy;
    private final int requestBatchSize;
    private static final Predicate<Notification<?>> NOT_UNSUBSCRIBED = new Predicate<Notification<?>>(){

        public boolean test(Notification<?> t) {
            return t != UnsubscribedNotificationHolder.unsubscribedNotification();
        }
    };

    private TransformerStateMachine(Callable<? extends State> initialState, Function3<? super State, ? super In, ? super FlowableEmitter<Out>, ? extends State> transition, BiPredicate<? super State, ? super FlowableEmitter<Out>> completion, BackpressureStrategy backpressureStrategy, int requestBatchSize) {
        Preconditions.checkNotNull(initialState);
        Preconditions.checkNotNull(transition);
        Preconditions.checkNotNull(completion);
        Preconditions.checkNotNull((Object)backpressureStrategy);
        Preconditions.checkArgument((requestBatchSize > 0 ? 1 : 0) != 0, (String)"initialRequest must be greater than zero");
        this.initialState = initialState;
        this.transition = transition;
        this.completion = completion;
        this.backpressureStrategy = backpressureStrategy;
        this.requestBatchSize = requestBatchSize;
    }

    public static <State, In, Out> FlowableTransformer<In, Out> create(Callable<? extends State> initialState, Function3<? super State, ? super In, ? super FlowableEmitter<Out>, ? extends State> transition, BiPredicate<? super State, ? super FlowableEmitter<Out>> completion, BackpressureStrategy backpressureStrategy, int requestBatchSize) {
        return new TransformerStateMachine<State, In, Out>(initialState, transition, completion, backpressureStrategy, requestBatchSize);
    }

    public Flowable<Out> apply(final Flowable<In> source) {
        return Flowable.defer((Callable)new Callable<Flowable<Out>>(){

            @Override
            public Flowable<Out> call() throws Exception {
                Mutable state = new Mutable(TransformerStateMachine.this.initialState.call());
                return source.materialize().flatMap(TransformerStateMachine.execute(TransformerStateMachine.this.transition, TransformerStateMachine.this.completion, state, TransformerStateMachine.this.backpressureStrategy), TransformerStateMachine.this.requestBatchSize).takeWhile(NOT_UNSUBSCRIBED).dematerialize();
            }
        });
    }

    private static <State, Out, In> Function<Notification<In>, Flowable<Notification<Out>>> execute(final Function3<? super State, ? super In, ? super FlowableEmitter<Out>, ? extends State> transition, final BiPredicate<? super State, ? super FlowableEmitter<Out>> completion, final Mutable<State> state, final BackpressureStrategy backpressureStrategy) {
        return new Function<Notification<In>, Flowable<Notification<Out>>>(){

            public Flowable<Notification<Out>> apply(final Notification<In> in) {
                return Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<Notification<Out>>(){

                    /*
                     * Exception decompiling
                     */
                    public void subscribe(FlowableEmitter<Notification<Out>> emitter) throws Exception {
                        /*
                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                         * 
                         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
                         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement.rewriteExpressions(ExpressionStatement.java:40)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                         */
                        throw new IllegalStateException("Decompilation failed");
                    }
                }, (BackpressureStrategy)backpressureStrategy);
            }
        };
    }

    private static <Out> NotificationEmitter<Out> wrap(FlowableEmitter<? super Notification<Out>> emitter) {
        return new NotificationEmitter(emitter);
    }

    static /* synthetic */ NotificationEmitter access$700(FlowableEmitter x0) {
        return TransformerStateMachine.wrap(x0);
    }

    private static final class NotificationEmitter<Out>
    implements FlowableEmitter<Out> {
        private final FlowableEmitter<? super Notification<Out>> emitter;

        NotificationEmitter(FlowableEmitter<? super Notification<Out>> emitter) {
            this.emitter = emitter;
        }

        public void onComplete() {
            this.emitter.onNext((Object)Notification.createOnComplete());
        }

        public void onError(Throwable e) {
            if (!this.tryOnError(e)) {
                RxJavaPlugins.onError((Throwable)e);
            }
        }

        public void onNext(Out t) {
            this.emitter.onNext((Object)Notification.createOnNext(t));
        }

        public void setDisposable(Disposable s) {
            throw new UnsupportedOperationException();
        }

        public void setCancellable(Cancellable c) {
            throw new UnsupportedOperationException();
        }

        public long requested() {
            return this.emitter.requested();
        }

        public boolean isCancelled() {
            return this.emitter.isCancelled();
        }

        public FlowableEmitter<Out> serialize() {
            throw new UnsupportedOperationException();
        }

        public boolean tryOnError(Throwable e) {
            if (this.emitter.isCancelled()) {
                return false;
            }
            this.emitter.onNext((Object)Notification.createOnError((Throwable)e));
            return true;
        }
    }

    private static final class Mutable<T> {
        T value;

        Mutable(T value) {
            this.value = value;
        }
    }

    private static final class UnsubscribedNotificationHolder {
        private static final Notification<Object> INSTANCE = Notification.createOnNext((Object)new Object());

        private UnsubscribedNotificationHolder() {
        }

        static <T> Notification<T> unsubscribedNotification() {
            return INSTANCE;
        }
    }
}

