/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2.internal.observable;

import io.reactivex.Observable;
import io.reactivex.Observer;
import java.util.concurrent.atomic.AtomicBoolean;

public final class OnSubscribeCacheResetable<T> {
    private final AtomicBoolean refresh = new AtomicBoolean(true);
    private final Observable<T> source;
    private volatile Observable<T> current;

    public OnSubscribeCacheResetable(Observable<T> source) {
        this.source = source;
        this.current = source;
    }

    public void subscribe(Observer<? super T> observer) {
        if (this.refresh.compareAndSet(true, false)) {
            this.current = this.source.cache();
        }
        this.current.subscribe(observer);
    }

    public void reset() {
        this.refresh.set(true);
    }
}

