/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2.buffertofile;

import com.github.davidmoten.rx2.buffertofile.DataSerializer;
import com.github.davidmoten.rx2.buffertofile.Serializer;
import com.github.davidmoten.rx2.buffertofile.SerializerString;
import com.github.davidmoten.rx2.internal.flowable.buffertofile.SerializerBytes;
import com.github.davidmoten.rx2.internal.flowable.buffertofile.SerializerJavaIO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;

public final class Serializers {
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    private Serializers() {
    }

    public static <T extends Serializable> Serializer<T> javaIO() {
        return new SerializerJavaIO();
    }

    public static Serializer<byte[]> bytes() {
        return new SerializerBytes();
    }

    public static Serializer<String> utf8() {
        return Serializers.string(UTF_8);
    }

    public static Serializer<String> string(Charset charset) {
        return new SerializerString(charset);
    }

    public static <T> Serializer<T> from(DataSerializer<T> ds) {
        return new WrappedDataSerializer<T>(ds);
    }

    private static final class WrappedDataSerializer<T>
    implements Serializer<T> {
        private final DataSerializer<T> ds;

        WrappedDataSerializer(DataSerializer<T> ds) {
            this.ds = ds;
        }

        @Override
        public byte[] serialize(T t) throws IOException {
            int cap = this.ds.sizeHint();
            ByteArrayOutputStream bytes = cap > 0 ? new ByteArrayOutputStream(this.ds.sizeHint()) : new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bytes);
            this.ds.serialize(t, out);
            out.close();
            return bytes.toByteArray();
        }

        @Override
        public T deserialize(byte[] bytes) throws IOException, ClassNotFoundException {
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            DataInputStream in = new DataInputStream(is);
            T t = this.ds.deserialize(in);
            in.close();
            return t;
        }
    }
}

