/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2.flowable;

import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.rx2.Flowables;
import com.github.davidmoten.rx2.StateMachine;
import com.github.davidmoten.rx2.StateMachine2;
import com.github.davidmoten.rx2.Statistics;
import com.github.davidmoten.rx2.buffertofile.Options;
import com.github.davidmoten.rx2.internal.flowable.FlowableCollectWhile;
import com.github.davidmoten.rx2.internal.flowable.FlowableDoOnEmpty;
import com.github.davidmoten.rx2.internal.flowable.FlowableMapLast;
import com.github.davidmoten.rx2.internal.flowable.FlowableMatch;
import com.github.davidmoten.rx2.internal.flowable.FlowableMaxRequest;
import com.github.davidmoten.rx2.internal.flowable.FlowableMinRequest;
import com.github.davidmoten.rx2.internal.flowable.FlowableRepeatingTransform;
import com.github.davidmoten.rx2.internal.flowable.FlowableReverse;
import com.github.davidmoten.rx2.internal.flowable.FlowableWindowMinMax;
import com.github.davidmoten.rx2.internal.flowable.TransformerStateMachine;
import com.github.davidmoten.rx2.util.Pair;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableTransformer;
import io.reactivex.Notification;
import io.reactivex.Observable;
import io.reactivex.functions.Action;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.BiPredicate;
import io.reactivex.functions.Function;
import io.reactivex.functions.Function3;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import org.reactivestreams.Publisher;

public final class Transformers {
    private static final Function<Observable<Object>, Observable<?>> FINISH_WHEN_SINGLE = new Function<Observable<Object>, Observable<?>>(){

        public Observable<?> apply(final Observable<Object> o) throws Exception {
            return Observable.defer((Callable)new Callable<Observable<Object>>(){
                final long[] count = new long[1];

                @Override
                public Observable<Object> call() throws Exception {
                    return o.materialize().flatMap((Function)new Function<Notification<Object>, Observable<Notification<Object>>>(){

                        public Observable<Notification<Object>> apply(Notification<Object> x) throws Exception {
                            if (x.isOnNext()) {
                                count[0] = count[0] + 1L;
                                if (count[0] > 1L) {
                                    return Observable.just(x);
                                }
                                return Observable.empty();
                            }
                            if (x.isOnComplete()) {
                                if (count[0] <= 1L) {
                                    return Observable.just(x);
                                }
                                return Observable.never();
                            }
                            return Observable.just(x);
                        }
                    }).dematerialize();
                }
            });
        }
    };

    private Transformers() {
    }

    public static <State, In, Out> FlowableTransformer<In, Out> stateMachine(Callable<? extends State> initialState, Function3<? super State, ? super In, ? super FlowableEmitter<Out>, ? extends State> transition, BiPredicate<? super State, ? super FlowableEmitter<Out>> completion, BackpressureStrategy backpressureStrategy, int requestBatchSize) {
        return TransformerStateMachine.create(initialState, transition, completion, backpressureStrategy, requestBatchSize);
    }

    public static StateMachine.Builder stateMachine() {
        return StateMachine.builder();
    }

    public static StateMachine2.Builder stateMachine2() {
        return StateMachine2.builder();
    }

    public static <T> FlowableTransformer<T, T> doOnEmpty(final Action action) {
        return new FlowableTransformer<T, T>(){

            public Publisher<T> apply(Flowable<T> upstream) {
                return new FlowableDoOnEmpty(upstream, action);
            }
        };
    }

    public static <T> FlowableTransformer<T, T> reverse() {
        return ReverseHolder.INSTANCE;
    }

    public static <T> FlowableTransformer<T, T> mapLast(final Function<? super T, ? extends T> function) {
        return new FlowableTransformer<T, T>(){

            public Publisher<T> apply(Flowable<T> upstream) {
                return new FlowableMapLast(upstream, function);
            }
        };
    }

    public static <A, B, K, C> Flowable<C> match(Flowable<A> a, Flowable<B> b, Function<? super A, K> aKey, Function<? super B, K> bKey, BiFunction<? super A, ? super B, C> combiner, int requestSize) {
        return new FlowableMatch<A, B, K, C>(a, b, aKey, bKey, combiner, requestSize);
    }

    public static <A, B, C, K> FlowableTransformer<A, C> matchWith(final Flowable<B> b, final Function<? super A, K> aKey, final Function<? super B, K> bKey, final BiFunction<? super A, ? super B, C> combiner, int requestSize) {
        return new FlowableTransformer<A, C>(){

            public Publisher<C> apply(Flowable<A> upstream) {
                return Flowables.match(upstream, b, aKey, bKey, combiner);
            }
        };
    }

    public static <A, B, C, K> FlowableTransformer<A, C> matchWith(Flowable<B> b, Function<? super A, K> aKey, Function<? super B, K> bKey, BiFunction<? super A, ? super B, C> combiner) {
        return Transformers.matchWith(b, aKey, bKey, combiner, 128);
    }

    public static Options.BuilderFlowable onBackpressureBufferToFile() {
        return Options.builderFlowable();
    }

    public static <T extends Number> FlowableTransformer<T, Statistics> collectStats() {
        return CollectStatsHolder.INSTANCE;
    }

    public static <T, R extends Number> FlowableTransformer<T, Pair<T, Statistics>> collectStats(final Function<? super T, ? extends R> function) {
        return new FlowableTransformer<T, Pair<T, Statistics>>(){

            public Flowable<Pair<T, Statistics>> apply(Flowable<T> source) {
                return source.scan(Pair.create(null, Statistics.create()), new BiFunction<Pair<T, Statistics>, T, Pair<T, Statistics>>(){

                    public Pair<T, Statistics> apply(Pair<T, Statistics> pair, T t) throws Exception {
                        return Pair.create(t, pair.b().add((Number)function.apply(t)));
                    }
                }).skip(1L);
            }
        };
    }

    public static <T, R> FlowableTransformer<T, R> collectWhile(final Callable<R> collectionFactory, final BiFunction<? super R, ? super T, ? extends R> add, final BiPredicate<? super R, ? super T> condition, final boolean emitRemainder) {
        return new FlowableTransformer<T, R>(){

            public Publisher<R> apply(Flowable<T> source) {
                return new FlowableCollectWhile(source, collectionFactory, add, condition, emitRemainder);
            }
        };
    }

    public static <T, R> FlowableTransformer<T, R> collectWhile(Callable<R> collectionFactory, BiFunction<? super R, ? super T, ? extends R> add, BiPredicate<? super R, ? super T> condition) {
        return Transformers.collectWhile(collectionFactory, add, condition, true);
    }

    /*
     * Exception decompiling
     */
    public static <T> FlowableTransformer<T, List<T>> toListWhile(BiPredicate<? super List<T>, ? super T> condition, boolean emitRemainder) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <T> FlowableTransformer<T, List<T>> toListWhile(BiPredicate<? super List<T>, ? super T> condition) {
        return Transformers.toListWhile(condition, true);
    }

    public static <T> FlowableTransformer<T, List<T>> bufferWhile(BiPredicate<? super List<T>, ? super T> condition, boolean emitRemainder) {
        return Transformers.toListWhile(condition, emitRemainder);
    }

    public static <T> FlowableTransformer<T, List<T>> bufferWhile(BiPredicate<? super List<T>, ? super T> condition) {
        return Transformers.toListWhile(condition);
    }

    public static <T extends Comparable<T>> FlowableTransformer<T, T> windowMax(int windowSize) {
        return Transformers.windowMax(windowSize, Transformers.<T>naturalComparator());
    }

    public static <T> FlowableTransformer<T, T> windowMax(final int windowSize, final Comparator<? super T> comparator) {
        return new FlowableTransformer<T, T>(){

            public Flowable<T> apply(Flowable<T> source) {
                return new FlowableWindowMinMax(source, windowSize, comparator, FlowableWindowMinMax.Metric.MAX);
            }
        };
    }

    public static <T extends Comparable<T>> FlowableTransformer<T, T> windowMin(int windowSize) {
        return Transformers.windowMin(windowSize, Transformers.<T>naturalComparator());
    }

    public static <T> FlowableTransformer<T, T> windowMin(final int windowSize, final Comparator<? super T> comparator) {
        return new FlowableTransformer<T, T>(){

            public Flowable<T> apply(Flowable<T> source) {
                return new FlowableWindowMinMax(source, windowSize, comparator, FlowableWindowMinMax.Metric.MIN);
            }
        };
    }

    private static <T extends Comparable<T>> Comparator<T> naturalComparator() {
        return NaturalComparatorHolder.INSTANCE;
    }

    public static <T> FlowableTransformer<T, T> maxRequest(final long ... maxRequest) {
        return new FlowableTransformer<T, T>(){

            public Publisher<T> apply(Flowable<T> source) {
                return new FlowableMaxRequest(source, maxRequest);
            }
        };
    }

    public static <T> FlowableTransformer<T, T> minRequest(final int ... minRequests) {
        return new FlowableTransformer<T, T>(){

            public Publisher<T> apply(Flowable<T> source) {
                return new FlowableMinRequest(source, minRequests);
            }
        };
    }

    public static <T> FlowableTransformer<T, T> rebatchRequests(final int minRequest, final long maxRequest, final boolean constrainFirstRequestMin) {
        Preconditions.checkArgument(((long)minRequest <= maxRequest ? 1 : 0) != 0, (String)"minRequest cannot be greater than maxRequest");
        return new FlowableTransformer<T, T>(){

            public Publisher<T> apply(Flowable<T> source) {
                if ((long)minRequest == maxRequest && constrainFirstRequestMin) {
                    return source.rebatchRequests(minRequest);
                }
                return source.compose(Transformers.minRequest(constrainFirstRequestMin ? minRequest : 1, minRequest)).compose(Transformers.maxRequest(maxRequest));
            }
        };
    }

    public static <T> FlowableTransformer<T, T> rebatchRequests(int minRequest, long maxRequest) {
        return Transformers.rebatchRequests(minRequest, maxRequest, true);
    }

    public static <T> Function<Flowable<T>, Flowable<T>> repeat(final Function<? super Flowable<T>, ? extends Flowable<T>> transform, final int maxChained, final long maxIterations, final Function<Observable<T>, Observable<?>> tester) {
        Preconditions.checkArgument((maxChained > 0 ? 1 : 0) != 0, (String)"maxChained must be > 0");
        Preconditions.checkArgument((maxIterations > 0L ? 1 : 0) != 0, (String)"maxIterations must be > 0");
        Preconditions.checkNotNull(transform, (String)"transform must not be null");
        Preconditions.checkNotNull(tester, (String)"tester must not be null");
        return new Function<Flowable<T>, Flowable<T>>(){

            public Flowable<T> apply(Flowable<T> source) {
                return new FlowableRepeatingTransform(source, transform, maxChained, maxIterations, tester);
            }
        };
    }

    /*
     * Exception decompiling
     */
    public static <T> Function<Flowable<T>, Flowable<T>> reduce(Function<? super Flowable<T>, ? extends Flowable<T>> reducer, int maxChained, long maxIterations) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static <T> Function<Observable<T>, Observable<?>> finishWhenSingle() {
        return FINISH_WHEN_SINGLE;
    }

    public static <T> Function<Flowable<T>, Flowable<T>> reduce(Function<? super Flowable<T>, ? extends Flowable<T>> reducer, int maxChained) {
        return Transformers.reduce(reducer, maxChained, Long.MAX_VALUE);
    }

    private static class NaturalComparatorHolder {
        static final Comparator<Comparable<Object>> INSTANCE = new Comparator<Comparable<Object>>(){

            @Override
            public int compare(Comparable<Object> o1, Comparable<Object> o2) {
                return o1.compareTo(o2);
            }
        };

        private NaturalComparatorHolder() {
        }
    }

    private static final class ListFactoryHolder {
        private static final Callable<List<Object>> INSTANCE = new Callable<List<Object>>(){

            @Override
            public List<Object> call() throws Exception {
                return new ArrayList<Object>();
            }
        };
        private static final BiFunction<List<Object>, Object, List<Object>> ADD = new BiFunction<List<Object>, Object, List<Object>>(){

            public List<Object> apply(List<Object> list, Object t) throws Exception {
                list.add(t);
                return list;
            }
        };

        private ListFactoryHolder() {
        }

        static <T> Callable<List<T>> factory() {
            return INSTANCE;
        }

        static <T> BiFunction<List<T>, T, List<T>> add() {
            return ADD;
        }
    }

    private static final class CollectStatsHolder {
        static final FlowableTransformer<Number, Statistics> INSTANCE = new FlowableTransformer<Number, Statistics>(){

            /*
             * Exception decompiling
             */
            public Flowable<Statistics> apply(Flowable<Number> source) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
                 *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };

        private CollectStatsHolder() {
        }
    }

    private static final class ReverseHolder {
        static final FlowableTransformer<Object, Object> INSTANCE = new FlowableTransformer<Object, Object>(){

            public Publisher<Object> apply(Flowable<Object> upstream) {
                return FlowableReverse.reverse(upstream);
            }
        };

        private ReverseHolder() {
        }
    }
}

