/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2.internal.flowable;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableMapLast<T>
extends Flowable<T> {
    private final Flowable<T> source;
    private final Function<? super T, ? extends T> function;

    public FlowableMapLast(Flowable<T> source, Function<? super T, ? extends T> function) {
        this.source = source;
        this.function = function;
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new MapLastSubscriber<T>(s, this.function));
    }

    private static final class MapLastSubscriber<T>
    implements FlowableSubscriber<T>,
    Subscription {
        private static final Object EMPTY = new Object();
        private final Subscriber<? super T> actual;
        private final Function<? super T, ? extends T> function;
        private final AtomicBoolean firstRequest = new AtomicBoolean(true);
        private T value = EMPTY;
        private Subscription parent;
        private boolean done;

        public MapLastSubscriber(Subscriber<? super T> actual, Function<? super T, ? extends T> function) {
            this.actual = actual;
            this.function = function;
        }

        public void onSubscribe(Subscription subscription) {
            if (SubscriptionHelper.validate((Subscription)this.parent, (Subscription)subscription)) {
                this.parent = subscription;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                return;
            }
            if (this.value == EMPTY) {
                this.value = t;
            } else {
                this.actual.onNext(this.value);
                this.value = t;
            }
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            if (this.value != EMPTY) {
                Object value2;
                try {
                    value2 = this.function.apply(this.value);
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal((Throwable)e);
                    this.parent.cancel();
                    this.onError(e);
                    return;
                }
                this.actual.onNext(value2);
            }
            this.done = true;
            this.actual.onComplete();
        }

        public void onError(Throwable e) {
            if (this.done) {
                return;
            }
            if (this.value != EMPTY) {
                this.actual.onNext(this.value);
            }
            this.done = true;
            this.actual.onError(e);
        }

        public void cancel() {
            this.parent.cancel();
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                if (this.firstRequest.compareAndSet(true, false)) {
                    long m = n + 1L;
                    if (m < 0L) {
                        m = Long.MAX_VALUE;
                    }
                    this.parent.request(m);
                } else {
                    this.parent.request(n);
                }
            }
        }
    }
}

