/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2.internal.flowable;

import com.github.davidmoten.guavamini.Preconditions;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableMaxRequest<T>
extends Flowable<T> {
    private final Flowable<T> source;
    private final long[] maxRequests;

    public FlowableMaxRequest(Flowable<T> source, long[] maxRequests) {
        Preconditions.checkArgument((maxRequests.length > 0 ? 1 : 0) != 0, (String)"maxRequests length must be greater than 0");
        for (int i = 0; i < maxRequests.length; ++i) {
            Preconditions.checkArgument((maxRequests[i] > 0L ? 1 : 0) != 0, (String)"maxRequests items must be greater than zero");
        }
        this.source = source;
        this.maxRequests = maxRequests;
    }

    protected void subscribeActual(Subscriber<? super T> child) {
        this.source.subscribe(new MaxRequestSubscriber<T>(this.maxRequests, child));
    }

    private static final class MaxRequestSubscriber<T>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription {
        private final long[] maxRequests;
        private int requestNum;
        private final Subscriber<? super T> child;
        private final AtomicLong requested = new AtomicLong();
        private Subscription parent;
        private long count;
        private volatile long nextRequest;
        private volatile boolean allArrived = true;

        MaxRequestSubscriber(long[] maxRequests, Subscriber<? super T> child) {
            this.maxRequests = maxRequests;
            this.child = child;
        }

        public void onSubscribe(Subscription parent) {
            if (SubscriptionHelper.validate((Subscription)this.parent, (Subscription)parent)) {
                this.parent = parent;
                this.child.onSubscribe((Subscription)this);
            }
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                BackpressureHelper.add((AtomicLong)this.requested, (long)n);
                this.requestMore();
            }
        }

        public void cancel() {
            this.parent.cancel();
        }

        public void onNext(T t) {
            block6: {
                if (this.count != Long.MAX_VALUE) {
                    --this.count;
                    if (this.count == -1L) {
                        long nr = this.nextRequest;
                        this.count = nr == Long.MAX_VALUE ? nr : nr - 1L;
                    }
                    if (this.count == 0L) {
                        long req;
                        long r;
                        long mr = this.peekNextMaxRequest();
                        do {
                            if ((r = this.requested.get()) == 0L) {
                                this.allArrived = true;
                                this.requestMore();
                            } else {
                                if (r != Long.MAX_VALUE) continue;
                                this.nextMaxRequest();
                                this.count = mr;
                                this.parent.request(mr);
                            }
                            break block6;
                        } while (!this.requested.compareAndSet(r, r - (req = Math.min(r, mr))));
                        this.nextMaxRequest();
                        this.count = req;
                        this.parent.request(req);
                    }
                }
            }
            this.child.onNext(t);
        }

        public void onError(Throwable t) {
            this.child.onError(t);
        }

        public void onComplete() {
            this.child.onComplete();
        }

        private void requestMore() {
            if (this.getAndIncrement() == 0) {
                int missed = 1;
                block0: do {
                    long req;
                    long r;
                    if (!this.allArrived) continue;
                    long mr = this.peekNextMaxRequest();
                    do {
                        r = this.requested.get();
                        req = Math.min(r, mr);
                        if (r == 0L) continue block0;
                    } while (r != Long.MAX_VALUE && !this.requested.compareAndSet(r, r - req));
                    this.nextMaxRequest();
                    this.allArrived = false;
                    this.nextRequest = req;
                    this.parent.request(req);
                } while ((missed = this.addAndGet(-missed)) != 0);
                return;
            }
        }

        private long peekNextMaxRequest() {
            return this.maxRequests[this.requestNum];
        }

        private void nextMaxRequest() {
            if (this.requestNum != this.maxRequests.length - 1) {
                ++this.requestNum;
            }
        }
    }
}

