/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2.internal.flowable;

import com.github.davidmoten.guavamini.Preconditions;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableWindowMinMax<T>
extends Flowable<T> {
    private final Flowable<T> source;
    private final int windowSize;
    private final Comparator<? super T> comparator;
    private final Metric metric;

    public FlowableWindowMinMax(Flowable<T> source, int windowSize, Comparator<? super T> comparator, Metric metric) {
        Preconditions.checkArgument((windowSize > 0 ? 1 : 0) != 0, (String)"windowSize must be greater than zero");
        Preconditions.checkNotNull(comparator, (String)"comparator cannot be null");
        Preconditions.checkNotNull((Object)((Object)metric), (String)"metric cannot be null");
        this.source = source;
        this.windowSize = windowSize;
        this.comparator = comparator;
        this.metric = metric;
    }

    protected void subscribeActual(Subscriber<? super T> child) {
        this.source.subscribe(new WindowMinMaxSubscriber<T>(this.windowSize, this.comparator, this.metric, child));
    }

    public static enum Metric {
        MIN,
        MAX;

    }

    private static final class WindowMinMaxSubscriber<T>
    implements FlowableSubscriber<T>,
    Subscription {
        private final int windowSize;
        private final Comparator<? super T> comparator;
        private final Metric metric;
        private final Subscriber<? super T> child;
        private final Map<Long, T> values;
        private final Deque<Long> indices;
        private long count = 0L;
        private Subscription parent;

        WindowMinMaxSubscriber(int windowSize, Comparator<? super T> comparator, Metric metric, Subscriber<? super T> child) {
            this.windowSize = windowSize;
            this.comparator = comparator;
            this.metric = metric;
            this.child = child;
            this.values = new HashMap<Long, T>(windowSize);
            this.indices = new ArrayDeque<Long>(windowSize);
        }

        public void onSubscribe(Subscription parent) {
            if (SubscriptionHelper.validate((Subscription)this.parent, (Subscription)parent)) {
                this.parent = parent;
                this.child.onSubscribe((Subscription)this);
                parent.request((long)(this.windowSize - 1));
            }
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                this.parent.request(n);
            }
        }

        public void cancel() {
            this.parent.cancel();
        }

        public void onComplete() {
            this.child.onComplete();
        }

        public void onError(Throwable e) {
            this.child.onError(e);
        }

        public void onNext(T t) {
            ++this.count;
            this.addToQueue(t);
            if (this.count >= (long)this.windowSize) {
                T value;
                Long head = this.indices.peekFirst();
                if (head == this.count - (long)this.windowSize) {
                    this.values.remove(this.indices.pollFirst());
                    value = this.values.get(this.indices.peekFirst());
                } else {
                    value = this.values.get(head);
                }
                this.child.onNext(value);
            }
        }

        private void addToQueue(T t) {
            Long v;
            while ((v = this.indices.peekLast()) != null && this.compare(t, this.values.get(v)) <= 0) {
                this.values.remove(this.indices.pollLast());
            }
            this.values.put(this.count, t);
            this.indices.offerLast(this.count);
        }

        private int compare(T a, T b) {
            if (this.metric == Metric.MIN) {
                return this.comparator.compare(a, b);
            }
            return this.comparator.compare(b, a);
        }
    }
}

