/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2.internal.flowable.buffertofile;

import com.github.davidmoten.guavamini.annotations.VisibleForTesting;
import com.github.davidmoten.rx2.internal.flowable.buffertofile.UnsafeAccess;
import java.io.File;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import sun.misc.Unsafe;
import sun.nio.ch.FileChannelImpl;

public final class MemoryMappedFile {
    private static final Unsafe unsafe = UnsafeAccess.unsafe();
    private static final Method mmap = MemoryMappedFile.getMethod(FileChannelImpl.class, "map0", Integer.TYPE, Long.TYPE, Long.TYPE);
    private static final Method unmmap = MemoryMappedFile.getMethod(FileChannelImpl.class, "unmap0", Long.TYPE, Long.TYPE);
    private static final int BYTE_ARRAY_OFFSET = unsafe.arrayBaseOffset(byte[].class);
    private final File file;
    private final long size;
    private long addr;

    public MemoryMappedFile(File file, long len) {
        this.file = file;
        this.size = MemoryMappedFile.roundTo4096(len);
        this.mapAndSetOffset();
    }

    @VisibleForTesting
    static Method getMethod(Class<?> cls, String name, Class<?> ... params) {
        Method m;
        try {
            m = cls.getDeclaredMethod(name, params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        m.setAccessible(true);
        return m;
    }

    private static long roundTo4096(long i) {
        return i + 4095L & 0xFFFFFFFFFFFFF000L;
    }

    private void mapAndSetOffset() {
        try {
            RandomAccessFile backingFile = new RandomAccessFile(this.file, "rw");
            backingFile.setLength(this.size);
            FileChannel ch = backingFile.getChannel();
            this.addr = (Long)mmap.invoke((Object)ch, 1, 0L, this.size);
            ch.close();
            backingFile.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            unmmap.invoke(null, this.addr, this.size);
            if (!this.file.delete()) {
                throw new RuntimeException("could not delete " + this.file);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public int getInt(long pos) {
        return unsafe.getInt(pos + this.addr);
    }

    public void putByte(long pos, byte val) {
        unsafe.putByte(pos + this.addr, val);
    }

    public void putInt(long pos, int val) {
        unsafe.putInt(pos + this.addr, val);
    }

    public void putOrderedInt(long pos, int val) {
        unsafe.putOrderedInt(null, pos + this.addr, val);
    }

    public int getIntVolatile(long pos) {
        return unsafe.getIntVolatile(null, pos + this.addr);
    }

    public void getBytes(long pos, byte[] data, long offset, long length) {
        unsafe.copyMemory(null, pos + this.addr, data, (long)BYTE_ARRAY_OFFSET + offset, length);
    }

    public void putBytes(long pos, byte[] data, long offset, long length) {
        unsafe.copyMemory(data, (long)BYTE_ARRAY_OFFSET + offset, null, pos + this.addr, length);
    }

    public byte getByte(long pos) {
        return unsafe.getByte(pos + this.addr);
    }
}

