/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2;

import com.github.davidmoten.rx2.Statistics;
import com.github.davidmoten.rx2.exceptions.ThrowingException;
import io.reactivex.functions.BiFunction;

public final class BiFunctions {
    private BiFunctions() {
    }

    public static <A, B, C> BiFunction<A, B, C> throwing() {
        return ThrowingHolder.INSTANCE;
    }

    public static <T extends Number> BiFunction<Statistics, T, Statistics> collectStats() {
        return new BiFunction<Statistics, T, Statistics>(){

            public Statistics apply(Statistics s, T t) {
                return s.add((Number)t);
            }
        };
    }

    public static <T, R, S> BiFunction<T, R, S> constant(final S value) {
        return new BiFunction<T, R, S>(){

            public S apply(T t1, R t2) throws Exception {
                return value;
            }
        };
    }

    public static <T, R, S> BiFunction<T, R, S> toNull() {
        return new BiFunction<T, R, S>(){

            public S apply(T t1, R t2) throws Exception {
                return null;
            }
        };
    }

    private static final class ThrowingHolder {
        static BiFunction<Object, Object, Object> INSTANCE = new BiFunction<Object, Object, Object>(){

            public Object apply(Object t1, Object t2) throws Exception {
                throw new ThrowingException();
            }
        };

        private ThrowingHolder() {
        }
    }
}

