/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2;

public final class Statistics {
    private final long count;
    private final double sumX;
    private final double sumX2;

    private Statistics(long count, double sumX, double sumX2) {
        this.count = count;
        this.sumX = sumX;
        this.sumX2 = sumX2;
    }

    public static Statistics create() {
        return new Statistics(0L, 0.0, 0.0);
    }

    public Statistics add(Number number) {
        double x = number.doubleValue();
        return new Statistics(this.count + 1L, this.sumX + x, this.sumX2 + x * x);
    }

    public long count() {
        return this.count;
    }

    public double sum() {
        return this.sumX;
    }

    public double sumSquares() {
        return this.sumX2;
    }

    public double mean() {
        return this.sumX / (double)this.count;
    }

    public double sd() {
        double m = this.mean();
        return Math.sqrt(this.sumX2 / (double)this.count - m * m);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Statistics [count=");
        builder.append(this.count);
        builder.append(", sum=");
        builder.append(this.sum());
        builder.append(", sumSquares=");
        builder.append(this.sumSquares());
        builder.append(", mean=");
        builder.append(this.mean());
        builder.append(", sd=");
        builder.append(this.sd());
        builder.append("]");
        return builder.toString();
    }
}

