/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2.flowable;

import io.reactivex.Flowable;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class Burst<T>
extends Flowable<T> {
    private final List<T> items;
    private final Throwable error;

    private Burst(Throwable error, List<T> items) {
        if (items.isEmpty()) {
            throw new IllegalArgumentException("items cannot be empty");
        }
        for (T item : items) {
            if (item != null) continue;
            throw new IllegalArgumentException("items cannot include null");
        }
        this.error = error;
        this.items = items;
    }

    protected void subscribeActual(final Subscriber<? super T> subscriber) {
        subscriber.onSubscribe(new Subscription(){
            final Queue<T> q;
            final AtomicLong requested;
            volatile boolean cancelled;
            {
                this.q = new ConcurrentLinkedQueue(Burst.this.items);
                this.requested = new AtomicLong();
            }

            public void request(long n) {
                if (this.cancelled) {
                    return;
                }
                if (SubscriptionHelper.validate((long)n) && BackpressureHelper.add((AtomicLong)this.requested, (long)n) == 0L) {
                    if (this.q.isEmpty()) {
                        return;
                    }
                    while (!this.q.isEmpty() && this.requested.get() > 0L) {
                        Object item = this.q.poll();
                        this.requested.decrementAndGet();
                        subscriber.onNext(item);
                    }
                    if (this.q.isEmpty()) {
                        if (Burst.this.error != null) {
                            subscriber.onError(Burst.this.error);
                        } else {
                            subscriber.onComplete();
                        }
                    }
                }
            }

            public void cancel() {
                this.cancelled = true;
            }
        });
    }

    public static <T> Builder<T> item(T item) {
        return Burst.items(item);
    }

    public static <T> Builder<T> items(T ... items) {
        return new Builder(Arrays.asList(items));
    }

    public static final class Builder<T> {
        private final List<T> items;
        private Throwable error;

        private Builder(List<T> items) {
            this.items = items;
        }

        public Flowable<T> error(Throwable e) {
            this.error = e;
            return this.create();
        }

        public Flowable<T> create() {
            return new Burst(this.error, this.items);
        }
    }
}

