/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2.internal.flowable;

import com.github.davidmoten.guavamini.annotations.VisibleForTesting;

public final class DelimitedStringLinkedList {
    private final String delimiter;
    private final StringBuilder b = new StringBuilder();
    private Node head;
    private Node tail;
    private int headPosition;
    private Node searchNode;
    private int searchPosition;
    private int nextLength;
    private boolean added;

    public DelimitedStringLinkedList(String delimiter) {
        this.delimiter = delimiter;
    }

    @VisibleForTesting
    int searchPosition() {
        return this.searchPosition;
    }

    public boolean addCalled() {
        return this.added;
    }

    public void add(String s) {
        this.added = true;
        if (s.length() == 0) {
            return;
        }
        if (this.head == null) {
            this.tail = this.head = new Node(s, null);
            this.headPosition = 0;
            this.searchPosition = 0;
            this.searchNode = this.head;
            this.nextLength = 0;
        } else {
            Node node;
            this.tail.next = node = new Node(s, null);
            this.tail = node;
            if (this.searchNode == null) {
                this.searchNode = node;
                this.searchPosition = 0;
            }
        }
    }

    public String remaining() {
        if (this.head == null) {
            return null;
        }
        this.b.setLength(0);
        Node n = this.head;
        do {
            if (n == this.head) {
                this.b.append(n.value.substring(this.headPosition, n.value.length()));
                continue;
            }
            this.b.append(n.value);
        } while ((n = n.next) != null);
        return this.b.toString();
    }

    public String next() {
        while (this.searchNode != null) {
            if (this.searchNode.value.charAt(this.searchPosition) == this.delimiter.charAt(0)) {
                boolean found;
                Node nd = this.searchNode;
                int pos = this.searchPosition + 1;
                int j = 1;
                while (j < this.delimiter.length()) {
                    if (pos == nd.value.length()) {
                        if (nd.next == null) break;
                        nd = nd.next;
                        pos = 0;
                    }
                    if (nd.value.charAt(pos) != this.delimiter.charAt(j)) break;
                    ++j;
                    ++pos;
                }
                boolean bl = found = j == this.delimiter.length();
                if (found) {
                    String result = this.extractFromHeadPositionToSearchPosition();
                    this.resetPositionsAfterExtract(nd, pos);
                    return result;
                }
            }
            ++this.nextLength;
            ++this.searchPosition;
            if (this.searchPosition != this.searchNode.value.length()) continue;
            if (this.searchNode.next == null) {
                this.searchNode = null;
                this.searchPosition = 0;
                break;
            }
            this.searchNode = this.searchNode.next;
            this.searchPosition = 0;
        }
        return null;
    }

    private String extractFromHeadPositionToSearchPosition() {
        this.b.setLength(0);
        this.b.ensureCapacity(this.nextLength);
        Node n = this.head;
        while (true) {
            if (n == this.searchNode && n == this.head) {
                this.b.append(n.value.substring(this.headPosition, this.searchPosition));
                break;
            }
            if (n == this.head) {
                this.b.append(n.value.substring(this.headPosition, n.value.length()));
            } else {
                if (n == this.searchNode) {
                    this.b.append(n.value.substring(0, this.searchPosition));
                    break;
                }
                this.b.append(n.value);
            }
            n = n.next;
        }
        if (this.nextLength != this.b.length()) {
            throw new RuntimeException("unexpected");
        }
        return this.b.toString();
    }

    private void resetPositionsAfterExtract(Node nd, int pos) {
        this.nextLength = 0;
        if (pos == nd.value.length()) {
            if (this.tail == nd) {
                this.tail = nd.next;
            }
            this.head = nd.next;
            this.headPosition = 0;
            this.searchPosition = 0;
            this.searchNode = this.head;
        } else {
            this.head = nd;
            this.headPosition = pos;
            if (this.headPosition == this.head.value.length()) {
                this.dropFirst();
            }
            this.searchNode = this.head;
            this.searchPosition = this.headPosition;
        }
    }

    private void dropFirst() {
        if (this.head.next == null) {
            this.tail = null;
            this.head = null;
            this.headPosition = 0;
        } else {
            if (this.tail == this.head) {
                this.tail = this.head.next;
            }
            Node h = this.head;
            this.head = this.head.next;
            h.next = null;
            this.headPosition = 0;
        }
    }

    public void clear() {
        this.head = null;
        this.tail = null;
        this.searchNode = null;
        this.headPosition = 0;
        this.searchPosition = 0;
    }

    private static final class Node {
        final String value;
        Node next;

        Node(String value, Node next) {
            this.value = value;
            this.next = next;
        }

        public String toString() {
            return "Node [value=" + this.value + ", next=" + this.next + "]";
        }
    }
}

