/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2.internal.flowable;

import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.util.RingBuffer;
import io.reactivex.Flowable;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableMergeInterleave<T>
extends Flowable<T> {
    private final int maxConcurrent;
    private final Publisher<? extends Publisher<? extends T>> sources;
    private final int batchSize;
    private boolean delayErrors;

    public FlowableMergeInterleave(Publisher<? extends Publisher<? extends T>> sources, int maxConcurrent, int batchSize, boolean delayErrors) {
        this.sources = sources;
        this.maxConcurrent = maxConcurrent;
        this.batchSize = batchSize;
        this.delayErrors = delayErrors;
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        MergeInterleaveSubscription<? super T> subscription = new MergeInterleaveSubscription<T>(this.sources, this.maxConcurrent, this.batchSize, this.delayErrors, s);
        s.onSubscribe(subscription);
    }

    private static interface BatchFinished {
        public void requestMore();
    }

    private static final class SourceComplete<T> {
        final Subscriber<T> subscriber;

        SourceComplete(Subscriber<T> subscriber) {
            this.subscriber = subscriber;
        }
    }

    private static final class SourceArrived<T> {
        final Publisher<? extends T> publisher;

        SourceArrived(Publisher<? extends T> publisher) {
            this.publisher = publisher;
        }
    }

    private static final class SourceSubscriber<T>
    implements Subscriber<T>,
    BatchFinished {
        private final MergeInterleaveSubscription<T> parent;
        private AtomicReference<Subscription> subscription = new AtomicReference();
        private int count = 0;

        SourceSubscriber(MergeInterleaveSubscription<T> parent) {
            this.parent = parent;
        }

        public void onSubscribe(Subscription s) {
            SubscriptionHelper.setOnce(this.subscription, (Subscription)s);
        }

        public void onNext(T t) {
            boolean batchFinished;
            ++this.count;
            boolean bl = batchFinished = this.count == ((MergeInterleaveSubscription)this.parent).batchSize;
            if (batchFinished) {
                this.count = 0;
            }
            this.parent.sourceNext(t, batchFinished ? this : null);
        }

        public void onError(Throwable t) {
            this.parent.sourceError(t);
        }

        public void onComplete() {
            this.parent.sourceComplete(this);
        }

        @Override
        public void requestMore() {
            this.subscription.get().request((long)((MergeInterleaveSubscription)this.parent).batchSize);
        }

        void cancel() {
            Subscription s;
            while (!this.subscription.compareAndSet(s = this.subscription.get(), (Subscription)SubscriptionHelper.CANCELLED)) {
            }
            s.cancel();
        }
    }

    private static final class MergeInterleaveSubscription<T>
    extends AtomicInteger
    implements Subscription,
    Subscriber<Publisher<? extends T>> {
        private static final long serialVersionUID = -6416801556759306113L;
        private static final Object SOURCES_COMPLETE = new Object();
        private final AtomicBoolean once = new AtomicBoolean();
        private final Publisher<? extends Publisher<? extends T>> sources;
        private final int maxConcurrent;
        private final int batchSize;
        private final boolean delayErrors;
        private Subscriber<? super T> subscriber;
        private Subscription subscription;
        private volatile boolean cancelled;
        private Throwable error;
        private volatile boolean finished;
        private final AtomicLong requested = new AtomicLong();
        private long emitted;
        private final RingBuffer<BatchFinished> batchFinished;
        private final SimplePlainQueue<Object> queue;
        private final List<SourceSubscriber<T>> sourceSubscribers = new ArrayList<SourceSubscriber<T>>();
        private boolean sourcesComplete;
        private long sourcesCount;

        public MergeInterleaveSubscription(Publisher<? extends Publisher<? extends T>> sources, int maxConcurrent, int batchSize, boolean delayErrors, Subscriber<? super T> subscriber) {
            this.sources = sources;
            this.maxConcurrent = maxConcurrent;
            this.batchSize = batchSize;
            this.delayErrors = delayErrors;
            this.subscriber = subscriber;
            this.queue = new MpscLinkedQueue();
            this.batchFinished = RingBuffer.create(maxConcurrent + 1);
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                BackpressureHelper.add((AtomicLong)this.requested, (long)n);
                if (this.once.compareAndSet(false, true)) {
                    this.sources.subscribe((Subscriber)this);
                    this.subscription.request((long)this.maxConcurrent);
                }
                this.drain();
            }
        }

        public void cancel() {
            this.cancelled = true;
        }

        public void onSubscribe(Subscription s) {
            this.subscription = s;
            this.drain();
        }

        public void onNext(Publisher<? extends T> f) {
            ++this.sourcesCount;
            this.queue.offer(new SourceArrived<T>(f));
            if (this.sourcesCount >= (long)this.maxConcurrent) {
                this.drain();
            }
        }

        public void onError(Throwable t) {
            this.error = t;
            this.finished = true;
            this.drain();
        }

        public void onComplete() {
            this.queue.offer(SOURCES_COMPLETE);
            this.drain();
        }

        private boolean tryCancelled() {
            if (this.cancelled) {
                this.cleanup();
                return true;
            }
            return false;
        }

        private void drain() {
            if (this.getAndIncrement() == 0) {
                int missed = 1;
                long e = this.emitted;
                long r = this.requested.get();
                do {
                    if (this.tryCancelled()) {
                        return;
                    }
                    if (e == r) {
                        r = this.requested.get();
                    }
                    while (e != r) {
                        Throwable err;
                        boolean d = this.finished;
                        if (d && !this.delayErrors && (err = this.error) != null) {
                            this.error = null;
                            this.cleanup();
                            this.subscriber.onError(err);
                            return;
                        }
                        Object o = this.queue.poll();
                        if (o == null) {
                            if (!d) break;
                            Throwable err2 = this.error;
                            if (err2 != null) {
                                this.error = null;
                                this.cleanup();
                                this.subscriber.onError(err2);
                            } else {
                                this.subscriber.onComplete();
                            }
                            return;
                        }
                        if (o instanceof BatchFinished) {
                            this.handleBatchFinished((BatchFinished)o);
                        } else if (o instanceof SourceArrived) {
                            this.handleSourceArrived((SourceArrived)o);
                        } else if (o instanceof SourceComplete) {
                            this.handleSourceComplete((SourceComplete)o);
                        } else if (o == SOURCES_COMPLETE) {
                            this.handleSourcesComplete();
                        } else {
                            this.subscriber.onNext(o);
                            ++e;
                        }
                        if (!this.tryCancelled()) continue;
                        return;
                    }
                    this.emitted = e;
                } while ((missed = this.addAndGet(-missed)) != 0);
                return;
            }
        }

        private void handleSourcesComplete() {
            this.sourcesComplete = true;
            if (this.sourceSubscribers.isEmpty()) {
                this.finished = true;
            }
        }

        private void handleBatchFinished(BatchFinished b) {
            Preconditions.checkNotNull((Object)b);
            boolean ok = this.batchFinished.offer(b);
            assert (ok);
            this.batchFinished.poll().requestMore();
        }

        private void cleanup() {
            this.subscription.cancel();
            for (SourceSubscriber<T> s : this.sourceSubscribers) {
                s.cancel();
            }
            this.sourceSubscribers.clear();
            this.queue.clear();
            this.batchFinished.clear();
        }

        private void handleSourceArrived(SourceArrived<T> event) {
            SourceSubscriber subscriber = new SourceSubscriber(this);
            this.sourceSubscribers.add(subscriber);
            this.queue.offer(subscriber);
            event.publisher.subscribe(subscriber);
        }

        private void handleSourceComplete(SourceComplete<T> event) {
            this.sourceSubscribers.remove(event.subscriber);
            if (!this.sourcesComplete) {
                this.subscription.request(1L);
            } else if (this.sourceSubscribers.isEmpty() && this.sourcesComplete) {
                this.finished = true;
            }
        }

        public void sourceError(Throwable t) {
            this.error = t;
            this.finished = true;
            this.drain();
        }

        public void sourceComplete(SourceSubscriber<T> sourceSubscriber) {
            this.queue.offer(new SourceComplete<T>(sourceSubscriber));
            this.drain();
        }

        public void sourceNext(T t, SourceSubscriber<T> sourceSubscriber) {
            this.queue.offer(t);
            if (sourceSubscriber != null) {
                this.queue.offer(sourceSubscriber);
            }
            this.drain();
        }
    }
}

