/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2.internal.flowable;

import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.rx2.internal.flowable.DelimitedStringLinkedList;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableStringSplitSimple
extends Flowable<String> {
    private final Flowable<String> source;
    private final String delimiter;

    public FlowableStringSplitSimple(Flowable<String> source, String delimiter) {
        Preconditions.checkNotNull(source);
        Preconditions.checkNotNull((Object)delimiter);
        Preconditions.checkArgument((delimiter.length() > 0 ? 1 : 0) != 0);
        this.source = source;
        this.delimiter = delimiter;
    }

    protected void subscribeActual(Subscriber<? super String> s) {
        this.source.subscribe((FlowableSubscriber)new StringSplitSubscriber(s, this.delimiter));
    }

    private static final class StringSplitSubscriber
    extends AtomicLong
    implements FlowableSubscriber<String>,
    Subscription {
        private final Subscriber<? super String> actual;
        private final transient SimplePlainQueue<String> queue = new SpscLinkedArrayQueue(16);
        private final AtomicInteger wip = new AtomicInteger();
        private final AtomicBoolean once = new AtomicBoolean();
        private final DelimitedStringLinkedList ss;
        private volatile boolean cancelled;
        private Subscription parent;
        private boolean unbounded;
        private Throwable error;
        private volatile boolean done;

        StringSplitSubscriber(Subscriber<? super String> actual, String delimiter) {
            this.actual = actual;
            this.ss = new DelimitedStringLinkedList(delimiter);
        }

        public void onSubscribe(Subscription subscription) {
            this.parent = subscription;
            this.actual.onSubscribe((Subscription)this);
        }

        public void cancel() {
            this.cancelled = true;
            this.parent.cancel();
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                BackpressureHelper.add((AtomicLong)this, (long)n);
                if (this.once.compareAndSet(false, true)) {
                    if (n == Long.MAX_VALUE) {
                        this.parent.request(Long.MAX_VALUE);
                        this.unbounded = true;
                    } else {
                        this.parent.request(1L);
                    }
                }
                this.drain();
            }
        }

        public void onNext(String t) {
            this.queue.offer((Object)t);
            this.drain();
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        public void onError(Throwable e) {
            this.error = e;
            this.done = true;
            this.drain();
        }

        private void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            do {
                long r = this.get();
                long e = 0L;
                while (e != r) {
                    if (this.cancelled) {
                        return;
                    }
                    if (this.find()) {
                        ++e;
                        continue;
                    }
                    boolean d = this.done;
                    String t = (String)this.queue.poll();
                    if (t == null) {
                        if (d) {
                            boolean checkCancelled;
                            Throwable err = this.error;
                            if (err != null) {
                                this.ss.clear();
                                this.actual.onError(err);
                                return;
                            }
                            String remaining = this.ss.remaining();
                            if (remaining != null) {
                                this.ss.clear();
                                this.queue.clear();
                                this.actual.onNext((Object)remaining);
                                ++e;
                                checkCancelled = true;
                            } else if (this.ss.addCalled()) {
                                this.ss.clear();
                                this.queue.clear();
                                this.actual.onNext((Object)"");
                                ++e;
                                checkCancelled = true;
                            } else {
                                checkCancelled = false;
                            }
                            if (!checkCancelled || !this.cancelled) {
                                this.actual.onComplete();
                            }
                            return;
                        }
                        if (this.unbounded) break;
                        this.parent.request(1L);
                        break;
                    }
                    this.ss.add(t);
                }
                if (e <= 0L || r == Long.MAX_VALUE) continue;
                this.addAndGet(-e);
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }

        private boolean find() {
            if (this.ss == null) {
                return false;
            }
            String s = this.ss.next();
            if (s != null) {
                this.actual.onNext((Object)s);
                return true;
            }
            return false;
        }
    }
}

