/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2;

import com.github.davidmoten.rx2.util.ZippedEntry;
import io.reactivex.Emitter;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.functions.BiConsumer;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class Bytes {
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    private Bytes() {
    }

    public static Flowable<byte[]> from(final InputStream is, final int bufferSize) {
        return Flowable.generate((Consumer)new Consumer<Emitter<byte[]>>(){

            public void accept(Emitter<byte[]> emitter) throws Exception {
                byte[] buffer = new byte[bufferSize];
                int count = is.read(buffer);
                if (count == -1) {
                    emitter.onComplete();
                } else if (count < bufferSize) {
                    emitter.onNext((Object)Arrays.copyOf(buffer, count));
                } else {
                    emitter.onNext((Object)buffer);
                }
            }
        });
    }

    public static Flowable<byte[]> from(File file) {
        return Bytes.from(file, 8192);
    }

    public static Flowable<byte[]> from(final File file, final int size) {
        Callable<InputStream> resourceFactory = new Callable<InputStream>(){

            @Override
            public InputStream call() throws FileNotFoundException {
                return new BufferedInputStream(new FileInputStream(file), size);
            }
        };
        Function<InputStream, Flowable<byte[]>> observableFactory = new Function<InputStream, Flowable<byte[]>>(){

            public Flowable<byte[]> apply(InputStream is) {
                return Bytes.from(is, size);
            }
        };
        return Flowable.using((Callable)resourceFactory, (Function)observableFactory, InputStreamCloseHolder.INSTANCE, (boolean)true);
    }

    public static Flowable<byte[]> from(InputStream is) {
        return Bytes.from(is, 8192);
    }

    public static Flowable<ZippedEntry> unzip(final File file) {
        Callable<ZipInputStream> resourceFactory = new Callable<ZipInputStream>(){

            @Override
            public ZipInputStream call() throws FileNotFoundException {
                return new ZipInputStream(new FileInputStream(file));
            }
        };
        Function<ZipInputStream, Flowable<ZippedEntry>> observableFactory = ZipHolder.OBSERVABLE_FACTORY;
        Consumer<ZipInputStream> disposeAction = ZipHolder.DISPOSER;
        return Flowable.using((Callable)resourceFactory, observableFactory, disposeAction);
    }

    public static Flowable<ZippedEntry> unzip(InputStream is) {
        return Bytes.unzip(new ZipInputStream(is));
    }

    public static Flowable<ZippedEntry> unzip(final ZipInputStream zis) {
        return Flowable.generate((Consumer)new Consumer<Emitter<ZippedEntry>>(){

            public void accept(Emitter<ZippedEntry> emitter) throws IOException {
                ZipEntry zipEntry = zis.getNextEntry();
                if (zipEntry != null) {
                    emitter.onNext((Object)new ZippedEntry(zipEntry, zis));
                } else {
                    zis.close();
                    emitter.onComplete();
                }
            }
        });
    }

    public static Single<byte[]> collect(Flowable<byte[]> source) {
        return source.collect(BosCreatorHolder.INSTANCE, BosCollectorHolder.INSTANCE).map(BosToArrayHolder.INSTANCE);
    }

    public static Function<Flowable<byte[]>, Single<byte[]>> collect() {
        return new Function<Flowable<byte[]>, Single<byte[]>>(){

            public Single<byte[]> apply(Flowable<byte[]> source) throws Exception {
                return Bytes.collect(source);
            }
        };
    }

    private static final class ZipHolder {
        static final Consumer<ZipInputStream> DISPOSER = new Consumer<ZipInputStream>(){

            public void accept(ZipInputStream zis) throws IOException {
                zis.close();
            }
        };
        static final Function<ZipInputStream, Flowable<ZippedEntry>> OBSERVABLE_FACTORY = new Function<ZipInputStream, Flowable<ZippedEntry>>(){

            public Flowable<ZippedEntry> apply(ZipInputStream zis) {
                return Bytes.unzip(zis);
            }
        };

        private ZipHolder() {
        }
    }

    private static final class BosToArrayHolder {
        static final Function<ByteArrayOutputStream, byte[]> INSTANCE = new Function<ByteArrayOutputStream, byte[]>(){

            public byte[] apply(ByteArrayOutputStream bos) {
                return bos.toByteArray();
            }
        };

        private BosToArrayHolder() {
        }
    }

    private static final class BosCollectorHolder {
        static final BiConsumer<ByteArrayOutputStream, byte[]> INSTANCE = new BiConsumer<ByteArrayOutputStream, byte[]>(){

            public void accept(ByteArrayOutputStream bos, byte[] bytes) throws IOException {
                bos.write(bytes);
            }
        };

        private BosCollectorHolder() {
        }
    }

    private static final class BosCreatorHolder {
        static final Callable<ByteArrayOutputStream> INSTANCE = new Callable<ByteArrayOutputStream>(){

            @Override
            public ByteArrayOutputStream call() {
                return new ByteArrayOutputStream();
            }
        };

        private BosCreatorHolder() {
        }
    }

    private static final class InputStreamCloseHolder {
        static final Consumer<InputStream> INSTANCE = new Consumer<InputStream>(){

            public void accept(InputStream is) throws IOException {
                is.close();
            }
        };

        private InputStreamCloseHolder() {
        }
    }
}

