/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2;

import com.github.davidmoten.rx2.exceptions.AssertionException;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.LongConsumer;
import java.io.Closeable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class Consumers {
    private Consumers() {
    }

    public static LongConsumer addLongTo(final List<Long> list) {
        return new LongConsumer(){

            public void accept(long t) throws Exception {
                list.add(t);
            }
        };
    }

    public static <T extends Closeable> Consumer<T> close() {
        return CloseHolder.INSTANCE;
    }

    public static Consumer<Object> increment(final AtomicInteger value) {
        return new Consumer<Object>(){

            public void accept(Object t) throws Exception {
                value.incrementAndGet();
            }
        };
    }

    public static Consumer<Throwable> printStackTrace() {
        return new Consumer<Throwable>(){

            public void accept(Throwable e) throws Exception {
                e.printStackTrace();
            }
        };
    }

    public static <T> Consumer<T> doNothing() {
        return DoNothingHolder.INSTANCE;
    }

    public static <T> Consumer<T> set(final AtomicReference<T> value) {
        return new Consumer<T>(){

            public void accept(T t) throws Exception {
                value.set(t);
            }
        };
    }

    public static Consumer<Integer> set(final AtomicInteger value) {
        return new Consumer<Integer>(){

            public void accept(Integer t) throws Exception {
                value.set(t);
            }
        };
    }

    public static Consumer<Object> decrement(final AtomicInteger value) {
        return new Consumer<Object>(){

            public void accept(Object t) throws Exception {
                value.decrementAndGet();
            }
        };
    }

    public static <T> Consumer<T> setToTrue(final AtomicBoolean value) {
        return new Consumer<Object>(){

            public void accept(Object t) throws Exception {
                value.set(true);
            }
        };
    }

    public static <T> Consumer<T> addTo(final List<T> list) {
        return new Consumer<T>(){

            public void accept(T t) throws Exception {
                list.add(t);
            }
        };
    }

    public static <T> Consumer<T> println() {
        return PrintlnHolder.INSTANCE;
    }

    public static Consumer<byte[]> assertBytesEquals(final byte[] expected) {
        return new Consumer<byte[]>(){

            public void accept(byte[] array) throws Exception {
                if (!Arrays.equals(expected, array)) {
                    throw new AssertionException("arrays not equal: expected=" + Arrays.toString(expected) + ",actual=" + Arrays.toString(array));
                }
            }
        };
    }

    private static final class PrintlnHolder {
        static final Consumer<Object> INSTANCE = new Consumer<Object>(){

            public void accept(Object t) throws Exception {
                System.out.println(t);
            }
        };

        private PrintlnHolder() {
        }
    }

    private static final class DoNothingHolder {
        static final Consumer<Object> INSTANCE = new Consumer<Object>(){

            public void accept(Object t) throws Exception {
            }
        };

        private DoNothingHolder() {
        }
    }

    private static final class CloseHolder {
        static final Consumer<Closeable> INSTANCE = new Consumer<Closeable>(){

            public void accept(Closeable t) throws Exception {
                t.close();
            }
        };

        private CloseHolder() {
        }
    }
}

