/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2;

import com.github.davidmoten.rx2.Callables;
import com.github.davidmoten.rx2.StateMachine;
import com.github.davidmoten.rx2.internal.flowable.FlowableStateMachine;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import java.util.concurrent.Callable;
import org.reactivestreams.Publisher;

public class StateMachine2 {
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder3<State, In, Out> {
        private static final int DEFAULT_REQUEST_SIZE = 1;
        private final Callable<State> initialState;
        private final StateMachine.Transition2<State, In, Out> transition;
        private StateMachine.Completion2<State, Out> completion = null;
        private StateMachine.Errored<State, Out> errored = null;
        private BackpressureStrategy backpressureStrategy = BackpressureStrategy.BUFFER;
        private int requestBatchSize = 1;

        private Builder3(Callable<State> initialState, StateMachine.Transition2<State, In, Out> transition) {
            this.initialState = initialState;
            this.transition = transition;
        }

        public Builder3<State, In, Out> completion(StateMachine.Completion2<State, Out> completion) {
            this.completion = completion;
            return this;
        }

        public Builder3<State, In, Out> errored(StateMachine.Errored<State, Out> errored) {
            this.errored = errored;
            return this;
        }

        public Builder3<State, In, Out> backpressureStrategy(BackpressureStrategy backpressureStrategy) {
            this.backpressureStrategy = backpressureStrategy;
            return this;
        }

        public Builder3<State, In, Out> requestBatchSize(int value) {
            this.requestBatchSize = value;
            return this;
        }

        public FlowableTransformer<In, Out> build() {
            return new FlowableTransformer<In, Out>(){

                public Publisher<Out> apply(Flowable<In> source) {
                    return new FlowableStateMachine(source, Builder3.this.initialState, Builder3.this.transition, Builder3.this.completion, Builder3.this.errored, Builder3.this.backpressureStrategy, Builder3.this.requestBatchSize);
                }
            };
        }
    }

    public static final class Builder2<State> {
        private final Callable<State> initialState;

        private Builder2(Callable<State> initialState) {
            this.initialState = initialState;
        }

        public <In, Out> Builder3<State, In, Out> transition(StateMachine.Transition2<State, In, Out> transition) {
            return new Builder3(this.initialState, transition);
        }
    }

    public static final class Builder {
        private Builder() {
        }

        public <State> Builder2<State> initialStateFactory(Callable<State> initialState) {
            return new Builder2(initialState);
        }

        public <State> Builder2<State> initialState(State initialState) {
            return this.initialStateFactory(Callables.constant(initialState));
        }
    }
}

