/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2.internal.flowable;

import io.reactivex.Flowable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.BiPredicate;
import io.reactivex.internal.fuseable.ConditionalSubscriber;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableCollectWhile<T, R>
extends Flowable<R> {
    private final Flowable<T> source;
    private final Callable<R> collectionFactory;
    private final BiFunction<? super R, ? super T, ? extends R> add;
    private final BiPredicate<? super R, ? super T> condition;
    private final boolean emitRemainder;

    public FlowableCollectWhile(Flowable<T> source, Callable<R> collectionFactory, BiFunction<? super R, ? super T, ? extends R> add, BiPredicate<? super R, ? super T> condition, boolean emitRemainder) {
        this.source = source;
        this.collectionFactory = collectionFactory;
        this.add = add;
        this.condition = condition;
        this.emitRemainder = emitRemainder;
    }

    protected void subscribeActual(Subscriber<? super R> child) {
        CollectWhileSubscriber<? super T, ? super R> subscriber = new CollectWhileSubscriber<T, R>(this.collectionFactory, this.add, this.condition, child, this.emitRemainder);
        this.source.subscribe(subscriber);
    }

    private static final class CollectWhileSubscriber<T, R>
    extends AtomicInteger
    implements Subscriber<T>,
    Subscription,
    ConditionalSubscriber<T> {
        private final Callable<R> collectionFactory;
        private final BiFunction<? super R, ? super T, ? extends R> add;
        private final BiPredicate<? super R, ? super T> condition;
        private final Subscriber<? super R> child;
        private final boolean emitRemainder;
        private final AtomicLong requested = new AtomicLong();
        private final SimplePlainQueue<R> queue = new SpscLinkedArrayQueue(16);
        private Subscription parent;
        private R collection;
        private volatile boolean done;
        private Throwable error;
        private volatile boolean cancelled;

        CollectWhileSubscriber(Callable<R> collectionFactory, BiFunction<? super R, ? super T, ? extends R> add, BiPredicate<? super R, ? super T> condition, Subscriber<? super R> child, boolean emitRemainder) {
            this.collectionFactory = collectionFactory;
            this.add = add;
            this.condition = condition;
            this.child = child;
            this.emitRemainder = emitRemainder;
        }

        public void onSubscribe(Subscription parent) {
            if (SubscriptionHelper.validate((Subscription)this.parent, (Subscription)parent)) {
                this.parent = parent;
                this.child.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (!this.tryOnNext(t)) {
                this.parent.request(1L);
            }
        }

        public boolean tryOnNext(T t) {
            boolean collect;
            if (this.done) {
                return true;
            }
            if (this.collection == null && !this.collectionCreated()) {
                return true;
            }
            try {
                collect = this.condition.test(this.collection, t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                this.onError(e);
                return true;
            }
            if (!collect) {
                this.queue.offer(this.collection);
                if (!this.collectionCreated()) {
                    return true;
                }
            }
            try {
                this.collection = this.add.apply(this.collection, t);
                if (this.collection == null) {
                    throw new NullPointerException("add function should not return null");
                }
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                this.onError(e);
                return true;
            }
            this.drain();
            return !collect;
        }

        public boolean collectionCreated() {
            try {
                this.collection = this.collectionFactory.call();
                if (this.collection == null) {
                    throw new NullPointerException("collectionFactory should not return null");
                }
                return true;
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                this.onError(e);
                return false;
            }
        }

        public void onError(Throwable e) {
            if (this.done) {
                RxJavaPlugins.onError((Throwable)e);
                return;
            }
            this.error = e;
            this.done = true;
            this.drain();
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            R col = this.collection;
            if (col != null) {
                this.collection = null;
                if (this.emitRemainder) {
                    this.queue.offer(col);
                }
            }
            this.done = true;
            this.drain();
        }

        private void drain() {
            if (this.getAndIncrement() == 0) {
                int missed = 1;
                do {
                    long e;
                    long r = this.requested.get();
                    for (e = 0L; e != r; ++e) {
                        if (this.cancelled) {
                            this.queue.clear();
                            return;
                        }
                        boolean d = this.done;
                        Object c = this.queue.poll();
                        if (c == null) {
                            if (!d) break;
                            Throwable err = this.error;
                            if (err != null) {
                                this.error = null;
                                this.child.onError(err);
                            } else {
                                this.child.onComplete();
                            }
                            return;
                        }
                        this.child.onNext(c);
                    }
                    if (e == 0L || r == Long.MAX_VALUE) continue;
                    this.requested.addAndGet(-e);
                } while ((missed = this.addAndGet(-missed)) != 0);
                return;
            }
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                BackpressureHelper.add((AtomicLong)this.requested, (long)n);
                this.parent.request(n);
                this.drain();
            }
        }

        public void cancel() {
            this.cancelled = true;
            this.parent.cancel();
        }
    }
}

