/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2.internal.flowable;

import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.rx2.StateMachine;
import com.github.davidmoten.rx2.functions.Consumer3;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiConsumer;
import io.reactivex.functions.Function3;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableStateMachine<State, In, Out>
extends Flowable<Out> {
    private final Flowable<In> source;
    private final Callable<? extends State> initialState;
    private final Function3<? super State, ? super In, ? super StateMachine.Emitter<Out>, ? extends State> transition;
    private final BiConsumer<? super State, ? super StateMachine.Emitter<Out>> completionAction;
    private final Consumer3<? super State, ? super Throwable, ? super StateMachine.Emitter<Out>> errorAction;
    private final BackpressureStrategy backpressureStrategy;
    private final int requestBatchSize;

    public FlowableStateMachine(Flowable<In> source, Callable<? extends State> initialState, Function3<? super State, ? super In, ? super StateMachine.Emitter<Out>, ? extends State> transition, BiConsumer<? super State, ? super StateMachine.Emitter<Out>> completionAction, Consumer3<? super State, ? super Throwable, ? super StateMachine.Emitter<Out>> errorAction, BackpressureStrategy backpressureStrategy, int requestBatchSize) {
        Preconditions.checkNotNull(initialState);
        Preconditions.checkNotNull(transition);
        Preconditions.checkNotNull((Object)backpressureStrategy);
        Preconditions.checkArgument((requestBatchSize > 0 ? 1 : 0) != 0, (String)"initialRequest must be greater than zero");
        this.source = source;
        this.initialState = initialState;
        this.transition = transition;
        this.completionAction = completionAction;
        this.errorAction = errorAction;
        this.backpressureStrategy = backpressureStrategy;
        this.requestBatchSize = requestBatchSize;
    }

    protected void subscribeActual(Subscriber<? super Out> child) {
        this.source.subscribe(new StateMachineSubscriber<State, In, Out>(this.initialState, this.transition, this.completionAction, this.errorAction, this.backpressureStrategy, this.requestBatchSize, child));
    }

    private static final class StateMachineSubscriber<State, In, Out>
    extends AtomicInteger
    implements Subscriber<In>,
    Subscription,
    StateMachine.Emitter<Out> {
        private final Callable<? extends State> initialState;
        private final Function3<? super State, ? super In, ? super StateMachine.Emitter<Out>, ? extends State> transition;
        private final BiConsumer<? super State, ? super StateMachine.Emitter<Out>> completionAction;
        private final Consumer3<? super State, ? super Throwable, ? super StateMachine.Emitter<Out>> errorAction;
        private final BackpressureStrategy backpressureStrategy;
        private final int requestBatchSize;
        private final SimplePlainQueue<Out> queue = new SpscLinkedArrayQueue(16);
        private final Subscriber<? super Out> child;
        private final AtomicLong requested = new AtomicLong();
        private Subscription parent;
        private volatile boolean cancelled;
        private State state;
        private boolean done;
        private volatile boolean done_;
        private Throwable error_;
        private boolean drainCalled;
        private long count;
        private volatile boolean requestsArrived = true;

        StateMachineSubscriber(Callable<? extends State> initialState, Function3<? super State, ? super In, ? super StateMachine.Emitter<Out>, ? extends State> transition, BiConsumer<? super State, ? super StateMachine.Emitter<Out>> completionAction, Consumer3<? super State, ? super Throwable, ? super StateMachine.Emitter<Out>> errorAction, BackpressureStrategy backpressureStrategy, int requestBatchSize, Subscriber<? super Out> child) {
            this.initialState = initialState;
            this.transition = transition;
            this.completionAction = completionAction;
            this.errorAction = errorAction;
            this.backpressureStrategy = backpressureStrategy;
            this.requestBatchSize = requestBatchSize;
            this.child = child;
            this.count = requestBatchSize;
        }

        public void onSubscribe(Subscription parent) {
            if (SubscriptionHelper.validate((Subscription)this.parent, (Subscription)parent)) {
                this.parent = parent;
                this.child.onSubscribe((Subscription)this);
            }
        }

        public void onNext(In t) {
            if (this.done) {
                return;
            }
            if (!this.createdState()) {
                return;
            }
            if (--this.count == 0L) {
                this.requestsArrived = true;
                this.count = this.requestBatchSize;
            }
            try {
                this.drainCalled = false;
                this.state = ObjectHelper.requireNonNull((Object)this.transition.apply(this.state, t, (Object)this), (String)"intermediate state cannot be null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                this.onError(e);
                return;
            }
            if (!this.drainCalled) {
                this.drain();
            }
        }

        private boolean createdState() {
            if (this.state == null) {
                try {
                    this.state = ObjectHelper.requireNonNull(this.initialState.call(), (String)"initial state cannot be null");
                    return true;
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal((Throwable)e);
                    this.done = true;
                    this.onError_(e);
                    return false;
                }
            }
            return true;
        }

        public void onError(Throwable e) {
            if (this.done) {
                RxJavaPlugins.onError((Throwable)e);
                return;
            }
            this.done = true;
            if (!this.createdState()) {
                return;
            }
            if (this.errorAction != null) {
                try {
                    this.errorAction.accept(this.state, e, this);
                }
                catch (Throwable err) {
                    Exceptions.throwIfFatal((Throwable)e);
                    this.onError_(err);
                    return;
                }
            } else {
                this.onError_(e);
            }
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            if (!this.createdState()) {
                return;
            }
            try {
                if (this.completionAction != null) {
                    this.completionAction.accept(this.state, (Object)this);
                } else {
                    this.onComplete_();
                }
                this.done = true;
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                this.onError(e);
                return;
            }
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                BackpressureHelper.add((AtomicLong)this.requested, (long)n);
                this.drain();
            }
        }

        public void cancel() {
            this.cancelled = true;
            this.parent.cancel();
        }

        @Override
        public void cancel_() {
            this.cancel();
        }

        @Override
        public void onNext_(Out t) {
            if (this.done_) {
                return;
            }
            this.queue.offer(t);
            this.drain();
        }

        @Override
        public void onError_(Throwable e) {
            if (this.done_) {
                RxJavaPlugins.onError((Throwable)e);
                return;
            }
            this.error_ = e;
            this.done_ = true;
            this.drain();
        }

        @Override
        public void onComplete_() {
            if (this.done_) {
                return;
            }
            this.done_ = true;
            this.drain();
        }

        public void drain() {
            this.drainCalled = true;
            if (this.getAndIncrement() == 0) {
                int missed = 1;
                do {
                    long e;
                    long r = this.requested.get();
                    boolean reqsArrived = this.requestsArrived;
                    for (e = 0L; e != r; ++e) {
                        if (this.cancelled) {
                            return;
                        }
                        boolean d = this.done_;
                        Object t = this.queue.poll();
                        if (t == null) {
                            if (!d) break;
                            Throwable err = this.error_;
                            if (err != null) {
                                this.cancel();
                                this.queue.clear();
                                this.child.onError(err);
                                return;
                            }
                            this.cancel();
                            this.queue.clear();
                            this.child.onComplete();
                            return;
                        }
                        this.child.onNext(t);
                    }
                    if (e != 0L && r != Long.MAX_VALUE) {
                        this.requested.addAndGet(-e);
                    }
                    if (e == r || !reqsArrived) continue;
                    this.requestsArrived = false;
                    this.parent.request((long)this.requestBatchSize);
                } while ((missed = this.addAndGet(-missed)) != 0);
                return;
            }
        }
    }
}

