/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2.internal.flowable.buffertofile;

import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.guavamini.annotations.VisibleForTesting;
import com.github.davidmoten.rx2.buffertofile.Options;
import com.github.davidmoten.rx2.buffertofile.Serializer;
import com.github.davidmoten.rx2.internal.flowable.buffertofile.PagedQueue;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableOnBackpressureBufferToFile<T>
extends Flowable<T> {
    private final Flowable<T> source;
    private final Observable<T> source2;
    private final Options options;
    private final Serializer<T> serializer;

    public FlowableOnBackpressureBufferToFile(Flowable<T> source, Observable<T> source2, Options options, Serializer<T> serializer) {
        Preconditions.checkArgument((boolean)(source != null ^ source2 != null));
        this.source = source;
        this.source2 = source2;
        this.options = options;
        this.serializer = serializer;
    }

    protected void subscribeActual(Subscriber<? super T> child) {
        PagedQueue queue = new PagedQueue(this.options.fileFactory(), this.options.pageSizeBytes());
        Scheduler.Worker worker = this.options.scheduler().createWorker();
        if (this.source != null) {
            this.source.subscribe(new BufferToFileSubscriberFlowable<T>(child, queue, this.serializer, worker));
        } else {
            this.source2.subscribe(new BufferToFileSubscriberObservable<T>(child, queue, this.serializer, worker));
        }
    }

    @VisibleForTesting
    public static void close(PagedQueue queue) {
        try {
            queue.close();
        }
        catch (Throwable err) {
            Exceptions.throwIfFatal((Throwable)err);
            RxJavaPlugins.onError((Throwable)err);
        }
    }

    @VisibleForTesting
    static abstract class BufferToFileSubscriber<T>
    extends AtomicInteger
    implements Runnable {
        protected final Subscriber<? super T> child;
        private final PagedQueue queue;
        private final Serializer<T> serializer;
        private final Scheduler.Worker worker;
        protected final AtomicLong requested = new AtomicLong();
        protected volatile boolean cancelled;
        private volatile boolean done;
        private Throwable error;

        BufferToFileSubscriber(Subscriber<? super T> child, PagedQueue queue, Serializer<T> serializer, Scheduler.Worker worker) {
            this.child = child;
            this.queue = queue;
            this.serializer = serializer;
            this.worker = worker;
        }

        public void onNext(T t) {
            try {
                this.queue.offer(this.serializer.serialize(t));
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                this.onError(e);
                return;
            }
            this.scheduleDrain();
        }

        public void onError(Throwable e) {
            this.error = e;
            this.done = true;
            this.scheduleDrain();
        }

        public void onComplete() {
            this.done = true;
            this.scheduleDrain();
        }

        protected void scheduleDrain() {
            if (this.getAndIncrement() == 0) {
                this.worker.schedule((Runnable)this);
            }
        }

        @Override
        public void run() {
            this.drain();
        }

        private void drain() {
            if (this.cancelled) {
                FlowableOnBackpressureBufferToFile.close(this.queue);
                this.worker.dispose();
                return;
            }
            int missed = 1;
            do {
                long e;
                long r = this.requested.get();
                for (e = 0L; e != r; ++e) {
                    byte[] bytes;
                    if (this.cancelled) {
                        FlowableOnBackpressureBufferToFile.close(this.queue);
                        this.worker.dispose();
                        return;
                    }
                    boolean isDone = this.done;
                    if (isDone && this.error != null) {
                        this.cancelNow();
                        this.child.onError(this.error);
                        return;
                    }
                    try {
                        bytes = this.queue.poll();
                    }
                    catch (Throwable err) {
                        Exceptions.throwIfFatal((Throwable)err);
                        this.cancelNow();
                        this.child.onError(err);
                        return;
                    }
                    if (bytes != null) {
                        Object t;
                        try {
                            t = ObjectHelper.requireNonNull(this.serializer.deserialize(bytes), (String)"Serializer.deserialize should not return null (because RxJava 2 does not support streams with null items");
                        }
                        catch (Throwable err) {
                            Exceptions.throwIfFatal((Throwable)err);
                            this.cancelNow();
                            this.child.onError(err);
                            return;
                        }
                        this.child.onNext(t);
                        continue;
                    }
                    if (!isDone) break;
                    this.cancelNow();
                    this.child.onComplete();
                    return;
                }
                if (e == 0L || r == Long.MAX_VALUE) continue;
                this.requested.addAndGet(-e);
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        private void cancelNow() {
            this.cancelled = true;
            this.cancelUpstream();
            FlowableOnBackpressureBufferToFile.close(this.queue);
            this.worker.dispose();
        }

        public abstract void cancelUpstream();
    }

    private static final class BufferToFileSubscriberObservable<T>
    extends BufferToFileSubscriber<T>
    implements Observer<T>,
    Subscription {
        private Disposable parent;

        BufferToFileSubscriberObservable(Subscriber<? super T> child, PagedQueue queue, Serializer<T> serializer, Scheduler.Worker worker) {
            super(child, queue, serializer, worker);
        }

        public void onSubscribe(Disposable d) {
            this.parent = d;
            this.child.onSubscribe((Subscription)this);
        }

        @Override
        public void onNext(T t) {
            super.onNext(t);
        }

        @Override
        public void onError(Throwable e) {
            super.onError(e);
        }

        @Override
        public void onComplete() {
            super.onComplete();
        }

        @Override
        public void cancelUpstream() {
            this.parent.dispose();
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                BackpressureHelper.add((AtomicLong)this.requested, (long)n);
                this.scheduleDrain();
            }
        }

        public void cancel() {
            this.cancelled = true;
            this.parent.dispose();
            this.scheduleDrain();
        }
    }

    @VisibleForTesting
    public static final class BufferToFileSubscriberFlowable<T>
    extends BufferToFileSubscriber<T>
    implements Subscriber<T>,
    Subscription {
        private Subscription parent;

        @VisibleForTesting
        public BufferToFileSubscriberFlowable(Subscriber<? super T> child, PagedQueue queue, Serializer<T> serializer, Scheduler.Worker worker) {
            super(child, queue, serializer, worker);
        }

        public void onSubscribe(Subscription parent) {
            if (SubscriptionHelper.validate((Subscription)this.parent, (Subscription)parent)) {
                this.parent = parent;
                this.child.onSubscribe((Subscription)this);
            }
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                BackpressureHelper.add((AtomicLong)this.requested, (long)n);
                this.parent.request(n);
                this.scheduleDrain();
            }
        }

        public void cancel() {
            this.cancelled = true;
            this.parent.cancel();
            this.scheduleDrain();
        }

        @Override
        public void onNext(T t) {
            super.onNext(t);
        }

        @Override
        public void onError(Throwable e) {
            super.onError(e);
        }

        @Override
        public void onComplete() {
            super.onComplete();
        }

        @Override
        public void cancelUpstream() {
            this.parent.cancel();
        }
    }
}

