/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.rx.jdbc;

import com.github.davidmoten.guavamini.Preconditions;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.functions.Action;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.davidmoten.rx.internal.FlowableSingleDeferUntilRequest;
import org.davidmoten.rx.jdbc.ConnectionProvider;
import org.davidmoten.rx.jdbc.SelectAutomappedBuilder;
import org.davidmoten.rx.jdbc.SelectBuilder;
import org.davidmoten.rx.jdbc.Sql;
import org.davidmoten.rx.jdbc.TransactedBuilder;
import org.davidmoten.rx.jdbc.TransactedConnection;
import org.davidmoten.rx.jdbc.Tx;
import org.davidmoten.rx.jdbc.TxImpl;
import org.davidmoten.rx.jdbc.UpdateBuilder;
import org.davidmoten.rx.jdbc.Util;
import org.davidmoten.rx.jdbc.exceptions.SQLRuntimeException;
import org.davidmoten.rx.jdbc.pool.NonBlockingConnectionPool;
import org.davidmoten.rx.jdbc.pool.Pools;
import org.davidmoten.rx.jdbc.pool.internal.ConnectionProviderBlockingPool;
import org.davidmoten.rx.pool.Pool;

public final class Database
implements AutoCloseable {
    private final Single<Connection> connection;
    private final Action onClose;
    private static final AtomicInteger testDbNumber = new AtomicInteger();
    public static final Object NULL_CLOB = new Object();
    public static final Object NULL_NUMBER = new Object();
    public static final Object NULL_BLOB = new Object();

    private Database(@Nonnull Single<Connection> connection, @Nonnull Action onClose) {
        this.connection = connection;
        this.onClose = onClose;
    }

    public static NonBlockingConnectionPool.Builder<Database> nonBlocking() {
        return new NonBlockingConnectionPool.Builder<Database>(pool -> Database.from(pool, () -> pool.close()));
    }

    public static Database from(@Nonnull String url, int maxPoolSize) {
        Preconditions.checkNotNull((Object)url, (String)"url cannot be null");
        Preconditions.checkArgument((maxPoolSize > 0 ? 1 : 0) != 0, (String)"maxPoolSize must be greater than 0");
        NonBlockingConnectionPool pool = Pools.nonBlocking().url(url).maxPoolSize(maxPoolSize).build();
        return Database.from(pool, () -> pool.close());
    }

    public static Database from(@Nonnull Pool<Connection> pool) {
        Preconditions.checkNotNull(pool, (String)"pool canot be null");
        return new Database((Single<Connection>)pool.member().map(x -> {
            if (x.value() == null) {
                throw new NullPointerException("connection is null!");
            }
            return (Connection)x.value();
        }), () -> pool.close());
    }

    public static Database from(@Nonnull Pool<Connection> pool, Action closeAction) {
        Preconditions.checkNotNull(pool, (String)"pool canot be null");
        return new Database((Single<Connection>)pool.member().map(x -> {
            if (x.value() == null) {
                throw new NullPointerException("connection is null!");
            }
            return (Connection)x.value();
        }), closeAction);
    }

    public static Database fromBlocking(@Nonnull ConnectionProvider cp) {
        return Database.from(new ConnectionProviderBlockingPool(cp));
    }

    public static Database fromBlocking(@Nonnull DataSource dataSource) {
        return Database.fromBlocking(Util.connectionProvider(dataSource));
    }

    public static Database test(int maxPoolSize) {
        Preconditions.checkArgument((maxPoolSize > 0 ? 1 : 0) != 0, (String)"maxPoolSize must be greater than 0");
        return Database.from(Pools.nonBlocking().connectionProvider(Database.testConnectionProvider()).maxPoolSize(maxPoolSize).build());
    }

    static ConnectionProvider testConnectionProvider() {
        return Database.testConnectionProvider(Database.nextUrl());
    }

    public static Database test() {
        return Database.test(3);
    }

    private static void createTestDatabase(@Nonnull Connection c) {
        try {
            Sql.statements(Database.class.getResourceAsStream("/database-test.sql")).stream().forEach(x -> {
                try (PreparedStatement s = c.prepareStatement((String)x);){
                    s.execute();
                }
                catch (SQLException e) {
                    throw new SQLRuntimeException(e);
                }
            });
            c.commit();
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    private static ConnectionProvider testConnectionProvider(final @Nonnull String url) {
        return new ConnectionProvider(){
            private final AtomicBoolean once = new AtomicBoolean();
            private final CountDownLatch latch = new CountDownLatch(1);

            @Override
            public Connection get() {
                try {
                    Connection c = DriverManager.getConnection(url);
                    if (this.once.compareAndSet(false, true)) {
                        Database.createTestDatabase(c);
                        this.latch.countDown();
                    } else if (!this.latch.await(1L, TimeUnit.MINUTES)) {
                        throw new SQLRuntimeException("waited 1 minute but test database was not created");
                    }
                    return c;
                }
                catch (SQLException e) {
                    throw new SQLRuntimeException(e);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void close() {
            }
        };
    }

    private static String nextUrl() {
        return "jdbc:derby:memory:derby" + testDbNumber.incrementAndGet() + ";create=true";
    }

    public Single<Connection> connection() {
        return this.connection;
    }

    public Flowable<Connection> connections() {
        return new FlowableSingleDeferUntilRequest<Connection>(this.connection).repeat();
    }

    @Override
    public void close() {
        try {
            this.onClose.run();
        }
        catch (Exception e) {
            throw new SQLRuntimeException(e);
        }
    }

    public <T> SelectAutomappedBuilder<T> select(@Nonnull Class<T> cls) {
        Preconditions.checkNotNull(cls, (String)"cls cannot be null");
        return new SelectAutomappedBuilder<T>(cls, this.connection, this);
    }

    public SelectBuilder select(@Nonnull String sql) {
        Preconditions.checkNotNull((Object)sql, (String)"sql cannot be null");
        return new SelectBuilder(sql, this.connection(), this);
    }

    public UpdateBuilder update(@Nonnull String sql) {
        Preconditions.checkNotNull((Object)sql, (String)"sql cannot be null");
        return new UpdateBuilder(sql, this.connection(), this);
    }

    public TransactedBuilder tx(@Nonnull Tx<?> tx) {
        Preconditions.checkNotNull(tx, (String)"tx cannot be null");
        TxImpl t = (TxImpl)tx;
        TransactedConnection c = t.connection().fork();
        return new TransactedBuilder(c, this);
    }

    public static Object toSentinelIfNull(@Nullable String s) {
        if (s == null) {
            return NULL_CLOB;
        }
        return s;
    }

    public static Object toSentinelIfNull(@Nullable byte[] bytes) {
        if (bytes == null) {
            return NULL_BLOB;
        }
        return bytes;
    }

    public static Object clob(@Nullable String s) {
        return Database.toSentinelIfNull(s);
    }

    public static Object blob(@Nullable byte[] bytes) {
        return Database.toSentinelIfNull(bytes);
    }
}

