/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.rx.jdbc;

import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.functions.Function;
import java.sql.Connection;
import java.util.List;
import javax.annotation.Nonnull;
import org.davidmoten.rx.jdbc.Database;
import org.davidmoten.rx.jdbc.SelectBuilder;
import org.davidmoten.rx.jdbc.TransactedSelectAutomappedBuilder;
import org.davidmoten.rx.jdbc.annotations.Query;
import org.davidmoten.rx.jdbc.exceptions.QueryAnnotationMissingException;

public final class SelectAutomappedBuilder<T> {
    final SelectBuilder selectBuilder;
    final Class<T> cls;
    private final Database db;

    SelectAutomappedBuilder(Class<T> cls, Single<Connection> connections, Database db) {
        this.selectBuilder = new SelectBuilder(SelectAutomappedBuilder.getSql(cls), connections, db);
        this.cls = cls;
        this.db = db;
    }

    private static String getSql(Class<?> cls) {
        Query q = cls.getDeclaredAnnotation(Query.class);
        if (q == null) {
            throw new QueryAnnotationMissingException("the sql for the automapped interface should be specified in a Query annotation on the interface");
        }
        return q.value();
    }

    public TransactedSelectAutomappedBuilder<T> transacted() {
        return new TransactedSelectAutomappedBuilder(this, this.db);
    }

    public TransactedSelectAutomappedBuilder<T> transactedValuesOnly() {
        return this.transacted().transactedValuesOnly();
    }

    public Flowable<T> get() {
        return this.selectBuilder.autoMap(this.cls);
    }

    public <R> Flowable<R> get(@Nonnull Function<? super T, ? extends R> function) {
        return this.get().map(function);
    }

    public SelectAutomappedBuilder<T> parameterStream(@Nonnull Flowable<?> values) {
        this.selectBuilder.parameterStream(values);
        return this;
    }

    public SelectAutomappedBuilder<T> fetchSize(int size) {
        this.selectBuilder.fetchSize(size);
        return this;
    }

    public SelectAutomappedBuilder<T> parameterListStream(@Nonnull Flowable<List<?>> valueLists) {
        this.selectBuilder.parameterListStream(valueLists);
        return this;
    }

    public SelectAutomappedBuilder<T> parameters(@Nonnull List<?> values) {
        this.selectBuilder.parameters(values);
        return this;
    }

    public SelectAutomappedBuilder<T> parameter(@Nonnull String name, Object value) {
        this.selectBuilder.parameter(name, value);
        return this;
    }

    public SelectAutomappedBuilder<T> parameter(Object value) {
        return this.parameters(value);
    }

    public SelectAutomappedBuilder<T> parameters(Object ... values) {
        this.selectBuilder.parameters(values);
        return this;
    }

    public Single<Long> count() {
        return this.selectBuilder.count();
    }
}

