/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.rx.jdbc;

import com.github.davidmoten.guavamini.Preconditions;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.sql.Connection;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.davidmoten.rx.jdbc.Database;
import org.davidmoten.rx.jdbc.Getter;
import org.davidmoten.rx.jdbc.GetterTx;
import org.davidmoten.rx.jdbc.ResultSetMapper;
import org.davidmoten.rx.jdbc.TransactedUpdateBuilder;
import org.davidmoten.rx.jdbc.Tx;
import org.davidmoten.rx.jdbc.TxImpl;
import org.davidmoten.rx.jdbc.Update;
import org.davidmoten.rx.jdbc.Util;

public final class TransactedReturnGeneratedKeysBuilder
implements GetterTx {
    private final TransactedUpdateBuilder update;
    private final Database db;

    TransactedReturnGeneratedKeysBuilder(TransactedUpdateBuilder update, Database db) {
        this.update = update;
        this.db = db;
    }

    @Override
    public <T> Flowable<Tx<T>> get(@Nonnull ResultSetMapper<? extends T> mapper) {
        Preconditions.checkNotNull(mapper, (String)"mapper cannot be null");
        return Flowable.defer(() -> {
            AtomicReference connection = new AtomicReference();
            Flowable o = Update.createReturnGeneratedKeys((Single<Connection>)this.update.updateBuilder.connections.map(c -> Util.toTransactedConnection(connection, c)), this.update.parameterGroupsToFlowable(), this.update.updateBuilder.sql, mapper, false);
            return o.materialize().flatMap(n -> Tx.toTx(n, (Connection)connection.get(), this.db)).doOnNext(tx -> {
                if (tx.isComplete()) {
                    ((TxImpl)tx).connection().commit();
                }
            });
        });
    }

    public ValuesOnly valuesOnly() {
        return new ValuesOnly(this);
    }

    public static final class ValuesOnly
    implements Getter {
        private final TransactedReturnGeneratedKeysBuilder builder;

        public ValuesOnly(TransactedReturnGeneratedKeysBuilder builder) {
            this.builder = builder;
        }

        @Override
        public <T> Flowable<T> get(ResultSetMapper<? extends T> function) {
            return this.builder.get(function).flatMap(Tx.flattenToValuesOnly());
        }
    }
}

