/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.rx.pool;

import com.github.davidmoten.guavamini.Preconditions;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.plugins.RxJavaPlugins;
import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.davidmoten.rx.pool.Checkin;
import org.davidmoten.rx.pool.DecoratingMember;
import org.davidmoten.rx.pool.Member;
import org.davidmoten.rx.pool.NonBlockingPool;
import org.davidmoten.rx.pool.PoolClosedException;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MemberSingle<T>
extends Single<Member<T>>
implements Subscription,
Closeable,
Runnable {
    final AtomicReference<Observers<T>> observers;
    private static final Logger log = LoggerFactory.getLogger(MemberSingle.class);
    static final Observers EMPTY = new Observers(new MemberSingleObserver[0], new boolean[0], 0, 0);
    private final SimplePlainQueue<DecoratingMember<T>> initializedAvailable;
    private final SimplePlainQueue<DecoratingMember<T>> notInitialized;
    private final SimplePlainQueue<DecoratingMember<T>> toBeReleased;
    private final SimplePlainQueue<DecoratingMember<T>> toBeChecked;
    private final AtomicInteger wip = new AtomicInteger();
    private final DecoratingMember<T>[] members;
    private final Scheduler scheduler;
    private final long createRetryIntervalMs;
    private final CompositeDisposable scheduled = new CompositeDisposable();
    final NonBlockingPool<T> pool;
    private final AtomicLong requested = new AtomicLong();
    private volatile boolean cancelled;

    MemberSingle(NonBlockingPool<T> pool) {
        Preconditions.checkNotNull(pool);
        this.initializedAvailable = new MpscLinkedQueue();
        this.notInitialized = new MpscLinkedQueue();
        this.toBeReleased = new MpscLinkedQueue();
        this.toBeChecked = new MpscLinkedQueue();
        this.members = this.createMembersArray(pool.maxSize, pool.checkinDecorator);
        for (DecoratingMember<T> m : this.members) {
            this.notInitialized.offer(m);
        }
        this.scheduler = pool.scheduler;
        this.createRetryIntervalMs = pool.createRetryIntervalMs;
        this.observers = new AtomicReference<Observers>(EMPTY);
        this.pool = pool;
    }

    private DecoratingMember<T>[] createMembersArray(int poolMaxSize, BiFunction<? super T, ? super Checkin, ? extends T> checkinDecorator) {
        DecoratingMember[] m = new DecoratingMember[poolMaxSize];
        for (int i = 0; i < m.length; ++i) {
            m[i] = new DecoratingMember<T>(null, checkinDecorator, this);
        }
        return m;
    }

    protected void subscribeActual(SingleObserver<? super Member<T>> observer) {
        MemberSingleObserver md = new MemberSingleObserver(observer, this);
        observer.onSubscribe(md);
        if (this.pool.isClosed()) {
            observer.onError((Throwable)new PoolClosedException());
            return;
        }
        this.add(md);
        if (md.isDisposed()) {
            this.remove(md);
        }
        this.requested.incrementAndGet();
        log.debug("subscribed");
        this.drain();
    }

    public void checkin(Member<T> member) {
        log.debug("checking in {}", member);
        DecoratingMember d = (DecoratingMember)member;
        d.scheduleRelease();
        d.markAsChecked();
        this.initializedAvailable.offer((Object)((DecoratingMember)member));
        this.drain();
    }

    public void addToBeReleased(DecoratingMember<T> member) {
        this.toBeReleased.offer(member);
        this.drain();
    }

    public void request(long n) {
        this.drain();
    }

    public void cancel() {
        log.debug("cancel called");
        this.cancelled = true;
        this.disposeAll();
    }

    @Override
    public void run() {
        try {
            this.drain();
        }
        catch (Throwable t) {
            RxJavaPlugins.onError((Throwable)t);
        }
    }

    private void drain() {
        log.debug("drain called");
        if (this.wip.getAndIncrement() == 0) {
            log.debug("drain loop starting");
            int missed = 1;
            do {
                this.scheduleReleases();
                this.scheduleChecks();
                long r = this.requested.get();
                log.debug("requested={}", (Object)r);
                long e = 0L;
                while (e != r) {
                    if (this.cancelled) {
                        this.disposeAll();
                        return;
                    }
                    Observers<T> obs = this.observers.get();
                    int c = obs.activeCount;
                    e += Math.max(0L, r - e - (long)c);
                    if (c == 0) break;
                    DecoratingMember m = (DecoratingMember)this.initializedAvailable.poll();
                    log.debug("poll of available members returns {}", (Object)m);
                    if (m == null) {
                        DecoratingMember m2 = (DecoratingMember)this.notInitialized.poll();
                        if (m2 == null) break;
                        ++e;
                        log.debug("scheduling member creation");
                        this.scheduled.add(this.scheduler.scheduleDirect((Runnable)new Creator(m2)));
                    } else if (!m.isReleasing() && !m.isChecking()) {
                        log.debug("trying to emit member");
                        if (this.shouldPerformHealthCheck(m)) {
                            log.debug("queueing member for health check {}", (Object)m);
                            this.toBeChecked.offer((Object)m);
                        } else {
                            log.debug("no health check required for {}", (Object)m);
                            if (this.tryEmit(obs, m)) {
                                ++e;
                            } else {
                                log.debug("no active observers");
                            }
                        }
                    }
                    this.scheduleReleases();
                    this.scheduleChecks();
                }
                if (e == 0L) continue;
                this.requested.addAndGet(-e);
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
            return;
        }
    }

    private boolean shouldPerformHealthCheck(DecoratingMember<T> m) {
        long now = this.scheduler.now(TimeUnit.MILLISECONDS);
        log.debug("schedule.now={}, lastCheck={}", (Object)now, (Object)m.lastCheckTime());
        return this.pool.idleTimeBeforeHealthCheckMs > 0L && now - m.lastCheckTime() >= this.pool.idleTimeBeforeHealthCheckMs;
    }

    private void scheduleChecks() {
        DecoratingMember m;
        while ((m = (DecoratingMember)this.toBeChecked.poll()) != null) {
            if (m.isReleasing()) continue;
            log.debug("scheduling check of {}", (Object)m);
            m.markAsChecking();
            this.scheduled.add(this.scheduler.scheduleDirect((Runnable)new Checker(m)));
        }
    }

    private void scheduleReleases() {
        DecoratingMember m;
        while ((m = (DecoratingMember)this.toBeReleased.poll()) != null) {
            log.debug("scheduling release of {}", (Object)m);
            m.markAsReleasing();
            this.scheduled.add(this.scheduler.scheduleDirect((Runnable)new Releaser(m)));
        }
    }

    private boolean tryEmit(Observers<T> obs, DecoratingMember<T> m) {
        int nextIndex;
        Observers<T> x;
        MemberSingleObserver oNext;
        block3: {
            block2: {
                boolean[] active;
                MemberSingleObserver o;
                int index = obs.index;
                oNext = o = obs.observers[index];
                do {
                    x = this.observers.get();
                    if (x.index != index || x.observers[index] != o) break block2;
                    active = new boolean[x.active.length];
                    System.arraycopy(x.active, 0, active, 0, active.length);
                    nextIndex = (index + 1) % active.length;
                    while (nextIndex != index && !active[nextIndex]) {
                        nextIndex = (nextIndex + 1) % active.length;
                    }
                    active[nextIndex] = false;
                } while (!this.observers.compareAndSet(x, new Observers(x.observers, active, x.activeCount - 1, nextIndex)));
                break block3;
            }
            m.checkin();
            return false;
        }
        oNext = x.observers[nextIndex];
        Scheduler.Worker worker = this.scheduler.createWorker();
        worker.schedule(new Emitter(worker, oNext, m));
        return true;
    }

    @Override
    public void close() {
        this.cancel();
    }

    private void disposeAll() {
        this.initializedAvailable.clear();
        this.toBeReleased.clear();
        this.notInitialized.clear();
        this.disposeValues();
        this.removeAllObservers();
    }

    private void disposeValues() {
        this.scheduled.dispose();
        for (DecoratingMember<T> member : this.members) {
            member.disposeValue();
        }
    }

    void add(@NonNull MemberSingleObserver<T> inner) {
        boolean[] active;
        MemberSingleObserver[] b;
        Observers<T> a;
        do {
            a = this.observers.get();
            int n = a.observers.length;
            b = new MemberSingleObserver[n + 1];
            System.arraycopy(a.observers, 0, b, 0, n);
            b[n] = inner;
            active = new boolean[n + 1];
            System.arraycopy(a.active, 0, active, 0, n);
            active[n] = true;
        } while (!this.observers.compareAndSet(a, new Observers(b, active, a.activeCount + 1, a.index)));
    }

    private void removeAllObservers() {
        Observers<T> a;
        while (!this.observers.compareAndSet(a = this.observers.get(), EMPTY)) {
        }
    }

    void remove(@NonNull MemberSingleObserver<T> inner) {
        Observers next;
        Observers<T> a;
        do {
            a = this.observers.get();
            int n = a.observers.length;
            if (n == 0) {
                return;
            }
            int j = -1;
            for (int i = 0; i < n; ++i) {
                if (a.observers[i] != inner) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (n == 1) {
                next = EMPTY;
                continue;
            }
            MemberSingleObserver[] b = new MemberSingleObserver[n - 1];
            System.arraycopy(a.observers, 0, b, 0, j);
            System.arraycopy(a.observers, j + 1, b, j, n - j - 1);
            boolean[] active = new boolean[n - 1];
            System.arraycopy(a.active, 0, active, 0, j);
            System.arraycopy(a.active, j + 1, active, j, n - j - 1);
            int nextActiveCount = a.active[j] ? a.activeCount - 1 : a.activeCount;
            next = a.index >= j && a.index > 0 ? new Observers(b, active, nextActiveCount, a.index - 1) : new Observers(b, active, nextActiveCount, a.index);
        } while (!this.observers.compareAndSet(a, next));
    }

    public void release(DecoratingMember<T> m) {
        log.debug("adding released member to notInitialized queue {}", m);
        this.notInitialized.offer(m);
        this.drain();
    }

    static final class MemberSingleObserver<T>
    extends AtomicReference<MemberSingle<T>>
    implements Disposable {
        private static final long serialVersionUID = -7650903191002190468L;
        final SingleObserver<? super Member<T>> child;

        MemberSingleObserver(SingleObserver<? super Member<T>> child, MemberSingle<T> parent) {
            this.child = child;
            this.lazySet(parent);
        }

        public void dispose() {
            MemberSingle parent = this.getAndSet(null);
            if (parent != null) {
                parent.remove(this);
            }
        }

        public boolean isDisposed() {
            return this.get() == null;
        }
    }

    private static final class Emitter<T>
    implements Runnable {
        private final Scheduler.Worker worker;
        private final MemberSingleObserver<T> observer;
        private final Member<T> m;

        Emitter(Scheduler.Worker worker, MemberSingleObserver<T> observer, Member<T> m) {
            this.worker = worker;
            this.observer = observer;
            this.m = m;
        }

        @Override
        public void run() {
            this.worker.dispose();
            try {
                this.observer.child.onSuccess(this.m);
            }
            catch (Throwable e) {
                RxJavaPlugins.onError((Throwable)e);
            }
            finally {
                this.observer.dispose();
            }
        }
    }

    private static final class Observers<T> {
        final MemberSingleObserver<T>[] observers;
        final boolean[] active;
        final int activeCount;
        final int index;

        Observers(MemberSingleObserver<T>[] observers, boolean[] active, int activeCount, int index) {
            Preconditions.checkArgument((observers.length > 0 || index == 0 ? 1 : 0) != 0, (String)"index must be -1 for zero length array");
            Preconditions.checkArgument((observers.length == active.length ? 1 : 0) != 0);
            this.observers = observers;
            this.index = index;
            this.active = active;
            this.activeCount = activeCount;
        }
    }

    final class Checker
    implements Runnable {
        private final DecoratingMember<T> m;

        Checker(DecoratingMember<T> m) {
            this.m = m;
        }

        @Override
        public void run() {
            try {
                log.debug("performing health check on {}", this.m);
                if (!MemberSingle.this.pool.healthCheck.test(this.m.value())) {
                    log.debug("failed health check");
                    this.m.disposeValue();
                    log.debug("scheduling recreation of member {}", this.m);
                    MemberSingle.this.scheduled.add(MemberSingle.this.scheduler.scheduleDirect(() -> {
                        log.debug("recreating member after failed health check {}", this.m);
                        MemberSingle.this.notInitialized.offer(this.m);
                        MemberSingle.this.drain();
                    }, MemberSingle.this.pool.createRetryIntervalMs, TimeUnit.MILLISECONDS));
                } else {
                    this.m.markAsChecked();
                    MemberSingle.this.initializedAvailable.offer(this.m);
                    MemberSingle.this.drain();
                }
            }
            catch (Throwable t) {
                RxJavaPlugins.onError((Throwable)t);
            }
        }
    }

    final class Releaser
    implements Runnable {
        private DecoratingMember<T> m;

        Releaser(DecoratingMember<T> m) {
            this.m = m;
        }

        @Override
        public void run() {
            try {
                this.m.disposeValue();
                MemberSingle.this.release(this.m);
            }
            catch (Throwable t) {
                RxJavaPlugins.onError((Throwable)t);
            }
        }
    }

    final class Creator
    implements Runnable {
        private final DecoratingMember<T> m;

        Creator(DecoratingMember<T> m) {
            this.m = m;
        }

        @Override
        public void run() {
            block3: {
                if (!MemberSingle.this.cancelled) {
                    try {
                        log.debug("creating value");
                        Object value = MemberSingle.this.pool.factory.call();
                        this.m.setValueAndClearReleasingFlag(value);
                        MemberSingle.this.requested.incrementAndGet();
                        MemberSingle.this.checkin(this.m);
                    }
                    catch (Throwable t) {
                        RxJavaPlugins.onError((Throwable)t);
                        if (MemberSingle.this.cancelled) break block3;
                        MemberSingle.this.scheduled.add(MemberSingle.this.scheduler.scheduleDirect((Runnable)this, MemberSingle.this.createRetryIntervalMs, TimeUnit.MILLISECONDS));
                    }
                }
            }
        }
    }
}

