/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.rx.pool;

import com.github.davidmoten.guavamini.Preconditions;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Predicate;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.davidmoten.rx.jdbc.pool.internal.Consumers;
import org.davidmoten.rx.pool.Checkin;
import org.davidmoten.rx.pool.Member;
import org.davidmoten.rx.pool.MemberSingle;
import org.davidmoten.rx.pool.Pool;

public final class NonBlockingPool<T>
implements Pool<T> {
    final Callable<? extends T> factory;
    final Predicate<? super T> healthCheck;
    final long idleTimeBeforeHealthCheckMs;
    final Consumer<? super T> disposer;
    final int maxSize;
    final long maxIdleTimeMs;
    final long createRetryIntervalMs;
    final BiFunction<? super T, ? super Checkin, ? extends T> checkinDecorator;
    final Scheduler scheduler;
    final Action closeAction;
    private final AtomicReference<MemberSingle<T>> member = new AtomicReference();
    private volatile boolean closed;

    NonBlockingPool(Callable<? extends T> factory, Predicate<? super T> healthCheck, Consumer<? super T> disposer, int maxSize, long idleTimeBeforeHealthCheckMs, long maxIdleTimeMs, long createRetryIntervalMs, BiFunction<? super T, ? super Checkin, ? extends T> checkinDecorator, Scheduler scheduler, Action closeAction) {
        Preconditions.checkNotNull(factory);
        Preconditions.checkNotNull(healthCheck);
        Preconditions.checkNotNull(disposer);
        Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull(checkinDecorator);
        Preconditions.checkNotNull((Object)scheduler);
        Preconditions.checkArgument((createRetryIntervalMs >= 0L ? 1 : 0) != 0, (String)"createRetryIntervalMs must be >=0");
        Preconditions.checkNotNull((Object)closeAction);
        Preconditions.checkArgument((maxIdleTimeMs >= 0L ? 1 : 0) != 0, (String)"maxIdleTime must be >=0");
        this.factory = factory;
        this.healthCheck = healthCheck;
        this.disposer = disposer;
        this.maxSize = maxSize;
        this.idleTimeBeforeHealthCheckMs = idleTimeBeforeHealthCheckMs;
        this.maxIdleTimeMs = maxIdleTimeMs;
        this.createRetryIntervalMs = createRetryIntervalMs;
        this.checkinDecorator = checkinDecorator;
        this.scheduler = scheduler;
        this.closeAction = closeAction;
    }

    private MemberSingle<T> createMember() {
        return new MemberSingle(this);
    }

    @Override
    public Single<Member<T>> member() {
        MemberSingle<T> m;
        do {
            if ((m = this.member.get()) == null) continue;
            return m;
        } while (!this.member.compareAndSet(null, m = this.createMember()));
        return m;
    }

    public void checkin(Member<T> m) {
        MemberSingle<T> mem = this.member.get();
        if (mem != null) {
            mem.checkin(m);
        }
    }

    @Override
    public void close() {
        MemberSingle<T> m;
        this.closed = true;
        do {
            if ((m = this.member.get()) != null) continue;
            return;
        } while (!this.member.compareAndSet(m, null));
        m.close();
        try {
            this.closeAction.run();
        }
        catch (Exception e) {
            RxJavaPlugins.onError((Throwable)e);
        }
    }

    boolean isClosed() {
        return this.closed;
    }

    public static <T> Builder<T> factory(Callable<T> factory) {
        return new Builder<T>().factory(factory);
    }

    public static class Builder<T> {
        private static final BiFunction<Object, Checkin, Object> DEFAULT_CHECKIN_DECORATOR = (x, y) -> x;
        private Callable<? extends T> factory;
        private Predicate<? super T> healthCheck = x -> true;
        private long idleTimeBeforeHealthCheckMs = 1000L;
        private Consumer<? super T> disposer = Consumers.doNothing();
        private int maxSize = 10;
        private long createRetryIntervalMs = 30000L;
        private Scheduler scheduler = Schedulers.computation();
        private long maxIdleTimeMs;
        private BiFunction<? super T, ? super Checkin, ? extends T> checkinDecorator = DEFAULT_CHECKIN_DECORATOR;
        private Action closeAction = () -> {};

        private Builder() {
        }

        public Builder<T> factory(Callable<? extends T> factory) {
            Preconditions.checkNotNull(factory);
            this.factory = factory;
            return this;
        }

        public Builder<T> healthCheck(Predicate<? super T> healthCheck) {
            Preconditions.checkNotNull(healthCheck);
            this.healthCheck = healthCheck;
            return this;
        }

        public Builder<T> idleTimeBeforeHealthCheck(long duration, TimeUnit unit) {
            Preconditions.checkArgument((duration >= 0L ? 1 : 0) != 0);
            this.idleTimeBeforeHealthCheckMs = unit.toMillis(duration);
            return this;
        }

        public Builder<T> maxIdleTime(long value, TimeUnit unit) {
            this.maxIdleTimeMs = unit.toMillis(value);
            return this;
        }

        public Builder<T> createRetryInterval(long duration, TimeUnit unit) {
            this.createRetryIntervalMs = unit.toMillis(duration);
            return this;
        }

        public Builder<T> disposer(Consumer<? super T> disposer) {
            Preconditions.checkNotNull(disposer);
            this.disposer = disposer;
            return this;
        }

        public Builder<T> maxSize(int maxSize) {
            Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0);
            this.maxSize = maxSize;
            return this;
        }

        public Builder<T> scheduler(Scheduler scheduler) {
            Preconditions.checkNotNull((Object)scheduler);
            this.scheduler = scheduler;
            return this;
        }

        public Builder<T> checkinDecorator(BiFunction<? super T, ? super Checkin, ? extends T> f) {
            this.checkinDecorator = f;
            return this;
        }

        public Builder<T> onClose(Action closeAction) {
            this.closeAction = closeAction;
            return this;
        }

        public NonBlockingPool<T> build() {
            return new NonBlockingPool<T>(this.factory, this.healthCheck, this.disposer, this.maxSize, this.idleTimeBeforeHealthCheckMs, this.maxIdleTimeMs, this.createRetryIntervalMs, this.checkinDecorator, this.scheduler, this.closeAction);
        }
    }
}

