/*
 * Decompiled with CFR 0.152.
 */
package bookstore;

import bookstore.Context;
import com.google.common.base.Optional;
import java.math.BigDecimal;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import scala.concurrent.duration.Duration;
import xuml.tools.model.compiler.runtime.CreationEvent;
import xuml.tools.model.compiler.runtime.EntityHelper;
import xuml.tools.model.compiler.runtime.Event;
import xuml.tools.model.compiler.runtime.Signaller;
import xuml.tools.model.compiler.runtime.ValidationException;
import xuml.tools.model.compiler.runtime.query.BooleanExpression;
import xuml.tools.model.compiler.runtime.query.Field;
import xuml.tools.model.compiler.runtime.query.NumericExpressionField;
import xuml.tools.model.compiler.runtime.query.SelectBuilder;
import xuml.tools.model.compiler.runtime.query.StringExpressionField;

@Entity
@Table(schema="bookstore", name="credit_card_charge")
public final class CreditCardCharge
implements xuml.tools.model.compiler.runtime.Entity<CreditCardCharge> {
    private static Signaller signaller;
    @Transient
    private EntityHelper _helper;
    @Id
    @Column(name="charge_id", nullable=false)
    private volatile Integer id = new Integer("1");
    @Column(name="account_number", nullable=true, length=64)
    private volatile String accountNumber = new String("");
    @Column(name="cardholder_name", nullable=true, length=512)
    private volatile String cardholderName = new String("");
    @Column(name="billing_address", nullable=true, length=512)
    private volatile String billingAddress = new String("");
    @Column(name="card_expiration_date", nullable=true, length=6)
    private volatile String cardExpirationDate = new String("");
    @Column(name="date_charge_made", nullable=true)
    @Temporal(value=TemporalType.DATE)
    private volatile Date dateChargeMade = new Date(0L);
    @Column(name="charge_amount", nullable=true, precision=2)
    private volatile Double chargeAmount = new Double("0");
    private static final BigDecimal CHARGEAMOUNT_UPPER_LIMIT;
    private static final BigDecimal CHARGEAMOUNT_LOWER_LIMIT;
    @Column(name="approval_code", nullable=true, length=64)
    private volatile String approvalCode = new String("");

    public CreditCardCharge() {
    }

    public CreditCardCharge(Integer id) {
        this.id = id;
    }

    public static CreditCardCharge create(Integer id) {
        return new CreditCardCharge(id);
    }

    public static CreditCardCharge create(CreationEvent<CreditCardCharge> creationEvent) {
        return Context.create(CreditCardCharge.class, creationEvent);
    }

    static void setSignaller_(Signaller sig) {
        signaller = sig;
    }

    public synchronized EntityHelper helper() {
        if (this._helper == null) {
            this._helper = new EntityHelper(signaller, (xuml.tools.model.compiler.runtime.Entity)this);
        }
        return this._helper;
    }

    public String uniqueId() {
        return CreditCardCharge.class.getName() + ":" + this.getId();
    }

    private void validateAccountNumber() {
        if (this.accountNumber == null || this.accountNumber.length() < 1) {
            throw new ValidationException("min length constraint not met");
        }
        if (this.accountNumber == null || !this.accountNumber.startsWith("")) {
            throw new ValidationException("prefix constraint not met");
        }
        if (this.accountNumber == null || !this.accountNumber.endsWith("")) {
            throw new ValidationException("suffix constraint not met");
        }
        if (this.accountNumber == null || !Pattern.matches(".*", this.accountNumber)) {
            throw new ValidationException("validation pattern constraint not met");
        }
    }

    private void validateCardholderName() {
        if (this.cardholderName == null || this.cardholderName.length() < 1) {
            throw new ValidationException("min length constraint not met");
        }
        if (this.cardholderName == null || !this.cardholderName.startsWith("")) {
            throw new ValidationException("prefix constraint not met");
        }
        if (this.cardholderName == null || !this.cardholderName.endsWith("")) {
            throw new ValidationException("suffix constraint not met");
        }
        if (this.cardholderName == null || !Pattern.matches(".*", this.cardholderName)) {
            throw new ValidationException("validation pattern constraint not met");
        }
    }

    private void validateBillingAddress() {
        if (this.billingAddress == null || this.billingAddress.length() < 1) {
            throw new ValidationException("min length constraint not met");
        }
        if (this.billingAddress == null || !this.billingAddress.startsWith("")) {
            throw new ValidationException("prefix constraint not met");
        }
        if (this.billingAddress == null || !this.billingAddress.endsWith("")) {
            throw new ValidationException("suffix constraint not met");
        }
        if (this.billingAddress == null || !Pattern.matches(".*", this.billingAddress)) {
            throw new ValidationException("validation pattern constraint not met");
        }
    }

    private void validateCardExpirationDate() {
        if (this.cardExpirationDate == null || this.cardExpirationDate.length() < 6) {
            throw new ValidationException("min length constraint not met");
        }
        if (this.cardExpirationDate == null || !this.cardExpirationDate.startsWith("")) {
            throw new ValidationException("prefix constraint not met");
        }
        if (this.cardExpirationDate == null || !this.cardExpirationDate.endsWith("")) {
            throw new ValidationException("suffix constraint not met");
        }
        if (this.cardExpirationDate == null || !Pattern.matches("[01][0-9][12][9012345][0-9]", this.cardExpirationDate)) {
            throw new ValidationException("validation pattern constraint not met");
        }
    }

    private void validateDateChargeMade() {
    }

    private void validateChargeAmount() {
        if (CHARGEAMOUNT_UPPER_LIMIT.doubleValue() < this.chargeAmount) {
            throw new ValidationException("upper limit of 999999999999 failed");
        }
        if (CHARGEAMOUNT_LOWER_LIMIT.doubleValue() > this.chargeAmount) {
            throw new ValidationException("lower limit of 0 failed");
        }
    }

    private void validateApprovalCode() {
        if (this.approvalCode == null || this.approvalCode.length() < 1) {
            throw new ValidationException("min length constraint not met");
        }
        if (this.approvalCode == null || !this.approvalCode.startsWith("")) {
            throw new ValidationException("prefix constraint not met");
        }
        if (this.approvalCode == null || !this.approvalCode.endsWith("")) {
            throw new ValidationException("suffix constraint not met");
        }
        if (this.approvalCode == null || !Pattern.matches(".*", this.approvalCode)) {
            throw new ValidationException("validation pattern constraint not met");
        }
    }

    @PreUpdate
    void validateBeforeUpdate() {
        this.validateAccountNumber();
        this.validateApprovalCode();
        this.validateBillingAddress();
        this.validateCardExpirationDate();
        this.validateCardholderName();
        this.validateChargeAmount();
        this.validateDateChargeMade();
    }

    @PrePersist
    void validateBeforePersist() {
        this.validateAccountNumber();
        this.validateApprovalCode();
        this.validateBillingAddress();
        this.validateCardExpirationDate();
        this.validateCardholderName();
        this.validateChargeAmount();
        this.validateDateChargeMade();
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public CreditCardCharge setAccountNumber_(String accountNumber) {
        this.setAccountNumber(accountNumber);
        return this;
    }

    public String getCardholderName() {
        return this.cardholderName;
    }

    public void setCardholderName(String cardholderName) {
        this.cardholderName = cardholderName;
    }

    public CreditCardCharge setCardholderName_(String cardholderName) {
        this.setCardholderName(cardholderName);
        return this;
    }

    public String getBillingAddress() {
        return this.billingAddress;
    }

    public void setBillingAddress(String billingAddress) {
        this.billingAddress = billingAddress;
    }

    public CreditCardCharge setBillingAddress_(String billingAddress) {
        this.setBillingAddress(billingAddress);
        return this;
    }

    public String getCardExpirationDate() {
        return this.cardExpirationDate;
    }

    public void setCardExpirationDate(String cardExpirationDate) {
        this.cardExpirationDate = cardExpirationDate;
    }

    public CreditCardCharge setCardExpirationDate_(String cardExpirationDate) {
        this.setCardExpirationDate(cardExpirationDate);
        return this;
    }

    public Date getDateChargeMade() {
        return this.dateChargeMade;
    }

    public void setDateChargeMade(Date dateChargeMade) {
        this.dateChargeMade = dateChargeMade;
    }

    public CreditCardCharge setDateChargeMade_(Date dateChargeMade) {
        this.setDateChargeMade(dateChargeMade);
        return this;
    }

    public Double getChargeAmount() {
        return this.chargeAmount;
    }

    public void setChargeAmount(Double chargeAmount) {
        this.chargeAmount = chargeAmount;
    }

    public CreditCardCharge setChargeAmount_(Double chargeAmount) {
        this.setChargeAmount(chargeAmount);
        return this;
    }

    public String getApprovalCode() {
        return this.approvalCode;
    }

    public void setApprovalCode(String approvalCode) {
        this.approvalCode = approvalCode;
    }

    public CreditCardCharge setApprovalCode_(String approvalCode) {
        this.setApprovalCode(approvalCode);
        return this;
    }

    public CreditCardCharge signal(Event<CreditCardCharge> event) {
        return this;
    }

    public CreditCardCharge signal(Event<CreditCardCharge> event, Duration delay) {
        return this;
    }

    public CreditCardCharge signal(Event<CreditCardCharge> event, long time) {
        return this.signal((Event)event, (Duration)Duration.create((long)(time - System.currentTimeMillis()), (TimeUnit)TimeUnit.MILLISECONDS));
    }

    public CreditCardCharge cancelSignal(String eventSignatureKey) {
        return this;
    }

    public CreditCardCharge cancelSignal(Event<CreditCardCharge> event) {
        return this.cancelSignal(event.signatureKey());
    }

    public CreditCardCharge event(Event<CreditCardCharge> event) {
        return this;
    }

    public CreditCardCharge merge(EntityManager em) {
        return (CreditCardCharge)em.merge((Object)this);
    }

    public CreditCardCharge persist(EntityManager em) {
        em.persist((Object)this);
        return this;
    }

    public CreditCardCharge remove(EntityManager em) {
        em.remove((Object)this);
        return this;
    }

    public CreditCardCharge remove() {
        Context.remove(this);
        return this;
    }

    public CreditCardCharge delete() {
        return this.remove();
    }

    public CreditCardCharge refresh(EntityManager em) {
        em.refresh((Object)this);
        return this;
    }

    public CreditCardCharge load(EntityManager em) {
        return this.merge(em).refresh(em);
    }

    public CreditCardCharge load() {
        return Context.load(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<CreditCardCharge> find(Integer id) {
        if (Context.em() != null) {
            return Optional.fromNullable((Object)Context.em().find(CreditCardCharge.class, (Object)id));
        }
        try (EntityManager em = Context.createEntityManager();){
            CreditCardCharge result = (CreditCardCharge)em.find(CreditCardCharge.class, (Object)id);
            Optional optional = Optional.fromNullable((Object)result);
            return optional;
        }
    }

    public static SelectBuilder<CreditCardCharge> select(BooleanExpression<CreditCardCharge> where) {
        return new SelectBuilder(where).entityClass(CreditCardCharge.class).info(signaller.getInfo());
    }

    public static SelectBuilder<CreditCardCharge> select() {
        return CreditCardCharge.select(null);
    }

    static {
        CHARGEAMOUNT_UPPER_LIMIT = new BigDecimal("999999999999");
        CHARGEAMOUNT_LOWER_LIMIT = new BigDecimal("0");
    }

    public static class Attribute {
        public static final StringExpressionField<CreditCardCharge> accountNumber = new StringExpressionField(new Field("accountNumber"));
        public static final StringExpressionField<CreditCardCharge> cardholderName = new StringExpressionField(new Field("cardholderName"));
        public static final StringExpressionField<CreditCardCharge> billingAddress = new StringExpressionField(new Field("billingAddress"));
        public static final StringExpressionField<CreditCardCharge> cardExpirationDate = new StringExpressionField(new Field("cardExpirationDate"));
        public static final StringExpressionField<CreditCardCharge> dateChargeMade = new StringExpressionField(new Field("dateChargeMade"));
        public static final NumericExpressionField<CreditCardCharge> chargeAmount = new NumericExpressionField(new Field("chargeAmount"));
        public static final StringExpressionField<CreditCardCharge> approvalCode = new StringExpressionField(new Field("approvalCode"));
        public static final NumericExpressionField<CreditCardCharge> id = new NumericExpressionField(new Field("id.id"));
    }
}

