/*
 * Decompiled with CFR 0.152.
 */
package bookstore;

import bookstore.Context;
import com.google.common.base.Optional;
import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import scala.concurrent.duration.Duration;
import xuml.tools.model.compiler.runtime.CreationEvent;
import xuml.tools.model.compiler.runtime.EntityHelper;
import xuml.tools.model.compiler.runtime.Event;
import xuml.tools.model.compiler.runtime.Signaller;
import xuml.tools.model.compiler.runtime.ValidationException;
import xuml.tools.model.compiler.runtime.query.BooleanExpression;
import xuml.tools.model.compiler.runtime.query.Field;
import xuml.tools.model.compiler.runtime.query.NumericExpressionField;
import xuml.tools.model.compiler.runtime.query.SelectBuilder;
import xuml.tools.model.compiler.runtime.query.StringExpressionField;

@Entity
@Table(schema="bookstore", name="customer")
public final class Customer
implements xuml.tools.model.compiler.runtime.Entity<Customer> {
    private static Signaller signaller;
    @Transient
    private EntityHelper _helper;
    @Id
    @Column(name="email", nullable=false, length=512)
    private volatile String id = new String("");
    @Column(name="name", nullable=true, length=512)
    private volatile String name = new String("");
    @Column(name="shipping_address", nullable=true, length=512)
    private volatile String shippingAddress = new String("");
    @Column(name="phone", nullable=true, length=256)
    private volatile String phone = new String("");
    @Column(name="purchases_made", nullable=true)
    private volatile Integer purchasesMade = new Integer("0");
    private static final BigDecimal PURCHASESMADE_UPPER_LIMIT;
    private static final BigDecimal PURCHASESMADE_LOWER_LIMIT;

    public Customer() {
    }

    public Customer(String id) {
        this.id = id;
    }

    public static Customer create(String id) {
        return new Customer(id);
    }

    public static Customer create(CreationEvent<Customer> creationEvent) {
        return Context.create(Customer.class, creationEvent);
    }

    static void setSignaller_(Signaller sig) {
        signaller = sig;
    }

    public synchronized EntityHelper helper() {
        if (this._helper == null) {
            this._helper = new EntityHelper(signaller, (xuml.tools.model.compiler.runtime.Entity)this);
        }
        return this._helper;
    }

    public String uniqueId() {
        return Customer.class.getName() + ":" + this.getId();
    }

    private void validateName() {
        if (this.name == null || this.name.length() < 1) {
            throw new ValidationException("min length constraint not met");
        }
        if (this.name == null || !this.name.startsWith("")) {
            throw new ValidationException("prefix constraint not met");
        }
        if (this.name == null || !this.name.endsWith("")) {
            throw new ValidationException("suffix constraint not met");
        }
        if (this.name == null || !Pattern.matches(".*", this.name)) {
            throw new ValidationException("validation pattern constraint not met");
        }
    }

    private void validateShippingAddress() {
        if (this.shippingAddress == null || this.shippingAddress.length() < 1) {
            throw new ValidationException("min length constraint not met");
        }
        if (this.shippingAddress == null || !this.shippingAddress.startsWith("")) {
            throw new ValidationException("prefix constraint not met");
        }
        if (this.shippingAddress == null || !this.shippingAddress.endsWith("")) {
            throw new ValidationException("suffix constraint not met");
        }
        if (this.shippingAddress == null || !Pattern.matches(".*", this.shippingAddress)) {
            throw new ValidationException("validation pattern constraint not met");
        }
    }

    private void validatePhone() {
        if (this.phone == null || this.phone.length() < 1) {
            throw new ValidationException("min length constraint not met");
        }
        if (this.phone == null || !this.phone.startsWith("")) {
            throw new ValidationException("prefix constraint not met");
        }
        if (this.phone == null || !this.phone.endsWith("")) {
            throw new ValidationException("suffix constraint not met");
        }
        if (this.phone == null || !Pattern.matches(".*", this.phone)) {
            throw new ValidationException("validation pattern constraint not met");
        }
    }

    private void validatePurchasesMade() {
        if (PURCHASESMADE_UPPER_LIMIT.doubleValue() < (double)this.purchasesMade.intValue()) {
            throw new ValidationException("upper limit of 999999999999 failed");
        }
        if (PURCHASESMADE_LOWER_LIMIT.doubleValue() > (double)this.purchasesMade.intValue()) {
            throw new ValidationException("lower limit of 0 failed");
        }
    }

    @PreUpdate
    void validateBeforeUpdate() {
        this.validateName();
        this.validatePhone();
        this.validatePurchasesMade();
        this.validateShippingAddress();
    }

    @PrePersist
    void validateBeforePersist() {
        this.validateName();
        this.validatePhone();
        this.validatePurchasesMade();
        this.validateShippingAddress();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Customer setName_(String name) {
        this.setName(name);
        return this;
    }

    public String getShippingAddress() {
        return this.shippingAddress;
    }

    public void setShippingAddress(String shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    public Customer setShippingAddress_(String shippingAddress) {
        this.setShippingAddress(shippingAddress);
        return this;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Customer setPhone_(String phone) {
        this.setPhone(phone);
        return this;
    }

    public Integer getPurchasesMade() {
        return this.purchasesMade;
    }

    public void setPurchasesMade(Integer purchasesMade) {
        this.purchasesMade = purchasesMade;
    }

    public Customer setPurchasesMade_(Integer purchasesMade) {
        this.setPurchasesMade(purchasesMade);
        return this;
    }

    public Customer signal(Event<Customer> event) {
        return this;
    }

    public Customer signal(Event<Customer> event, Duration delay) {
        return this;
    }

    public Customer signal(Event<Customer> event, long time) {
        return this.signal((Event)event, (Duration)Duration.create((long)(time - System.currentTimeMillis()), (TimeUnit)TimeUnit.MILLISECONDS));
    }

    public Customer cancelSignal(String eventSignatureKey) {
        return this;
    }

    public Customer cancelSignal(Event<Customer> event) {
        return this.cancelSignal(event.signatureKey());
    }

    public Customer event(Event<Customer> event) {
        return this;
    }

    public Customer merge(EntityManager em) {
        return (Customer)em.merge((Object)this);
    }

    public Customer persist(EntityManager em) {
        em.persist((Object)this);
        return this;
    }

    public Customer remove(EntityManager em) {
        em.remove((Object)this);
        return this;
    }

    public Customer remove() {
        Context.remove(this);
        return this;
    }

    public Customer delete() {
        return this.remove();
    }

    public Customer refresh(EntityManager em) {
        em.refresh((Object)this);
        return this;
    }

    public Customer load(EntityManager em) {
        return this.merge(em).refresh(em);
    }

    public Customer load() {
        return Context.load(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<Customer> find(String id) {
        if (Context.em() != null) {
            return Optional.fromNullable((Object)Context.em().find(Customer.class, (Object)id));
        }
        try (EntityManager em = Context.createEntityManager();){
            Customer result = (Customer)em.find(Customer.class, (Object)id);
            Optional optional = Optional.fromNullable((Object)result);
            return optional;
        }
    }

    public static SelectBuilder<Customer> select(BooleanExpression<Customer> where) {
        return new SelectBuilder(where).entityClass(Customer.class).info(signaller.getInfo());
    }

    public static SelectBuilder<Customer> select() {
        return Customer.select(null);
    }

    static {
        PURCHASESMADE_UPPER_LIMIT = new BigDecimal("999999999999");
        PURCHASESMADE_LOWER_LIMIT = new BigDecimal("0");
    }

    public static class Attribute {
        public static final StringExpressionField<Customer> name = new StringExpressionField(new Field("name"));
        public static final StringExpressionField<Customer> shippingAddress = new StringExpressionField(new Field("shippingAddress"));
        public static final StringExpressionField<Customer> phone = new StringExpressionField(new Field("phone"));
        public static final NumericExpressionField<Customer> purchasesMade = new NumericExpressionField(new Field("purchasesMade"));
        public static final StringExpressionField<Customer> id = new StringExpressionField(new Field("id.id"));
    }
}

